/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.BrokerAZDistribution;
import software.amazon.awssdk.services.kafka.model.StorageInfo;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerNodeGroupInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerNodeGroupInfo> {
    private static final SdkField<String> BROKER_AZ_DISTRIBUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BrokerAZDistribution").getter(BrokerNodeGroupInfo.getter(BrokerNodeGroupInfo::brokerAZDistributionAsString)).setter(BrokerNodeGroupInfo.setter(Builder::brokerAZDistribution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerAZDistribution").build()}).build();
    private static final SdkField<List<String>> CLIENT_SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientSubnets").getter(BrokerNodeGroupInfo.getter(BrokerNodeGroupInfo::clientSubnets)).setter(BrokerNodeGroupInfo.setter(Builder::clientSubnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(BrokerNodeGroupInfo.getter(BrokerNodeGroupInfo::instanceType)).setter(BrokerNodeGroupInfo.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(BrokerNodeGroupInfo.getter(BrokerNodeGroupInfo::securityGroups)).setter(BrokerNodeGroupInfo.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<StorageInfo> STORAGE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StorageInfo").getter(BrokerNodeGroupInfo.getter(BrokerNodeGroupInfo::storageInfo)).setter(BrokerNodeGroupInfo.setter(Builder::storageInfo)).constructor(StorageInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_AZ_DISTRIBUTION_FIELD, CLIENT_SUBNETS_FIELD, INSTANCE_TYPE_FIELD, SECURITY_GROUPS_FIELD, STORAGE_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String brokerAZDistribution;
    private final List<String> clientSubnets;
    private final String instanceType;
    private final List<String> securityGroups;
    private final StorageInfo storageInfo;

    private BrokerNodeGroupInfo(BuilderImpl builder) {
        this.brokerAZDistribution = builder.brokerAZDistribution;
        this.clientSubnets = builder.clientSubnets;
        this.instanceType = builder.instanceType;
        this.securityGroups = builder.securityGroups;
        this.storageInfo = builder.storageInfo;
    }

    public BrokerAZDistribution brokerAZDistribution() {
        return BrokerAZDistribution.fromValue(this.brokerAZDistribution);
    }

    public String brokerAZDistributionAsString() {
        return this.brokerAZDistribution;
    }

    public boolean hasClientSubnets() {
        return this.clientSubnets != null && !(this.clientSubnets instanceof SdkAutoConstructList);
    }

    public List<String> clientSubnets() {
        return this.clientSubnets;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public StorageInfo storageInfo() {
        return this.storageInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerAZDistributionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientSubnets() ? this.clientSubnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeGroupInfo)) {
            return false;
        }
        BrokerNodeGroupInfo other = (BrokerNodeGroupInfo)obj;
        return Objects.equals(this.brokerAZDistributionAsString(), other.brokerAZDistributionAsString()) && this.hasClientSubnets() == other.hasClientSubnets() && Objects.equals(this.clientSubnets(), other.clientSubnets()) && Objects.equals(this.instanceType(), other.instanceType()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.storageInfo(), other.storageInfo());
    }

    public String toString() {
        return ToString.builder((String)"BrokerNodeGroupInfo").add("BrokerAZDistribution", (Object)this.brokerAZDistributionAsString()).add("ClientSubnets", this.hasClientSubnets() ? this.clientSubnets() : null).add("InstanceType", (Object)this.instanceType()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("StorageInfo", (Object)this.storageInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerAZDistribution": {
                return Optional.ofNullable(clazz.cast(this.brokerAZDistributionAsString()));
            }
            case "ClientSubnets": {
                return Optional.ofNullable(clazz.cast(this.clientSubnets()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "StorageInfo": {
                return Optional.ofNullable(clazz.cast(this.storageInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrokerNodeGroupInfo, T> g) {
        return obj -> g.apply((BrokerNodeGroupInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String brokerAZDistribution;
        private List<String> clientSubnets = DefaultSdkAutoConstructList.getInstance();
        private String instanceType;
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private StorageInfo storageInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerNodeGroupInfo model) {
            this.brokerAZDistribution(model.brokerAZDistribution);
            this.clientSubnets(model.clientSubnets);
            this.instanceType(model.instanceType);
            this.securityGroups(model.securityGroups);
            this.storageInfo(model.storageInfo);
        }

        public final String getBrokerAZDistribution() {
            return this.brokerAZDistribution;
        }

        @Override
        public final Builder brokerAZDistribution(String brokerAZDistribution) {
            this.brokerAZDistribution = brokerAZDistribution;
            return this;
        }

        @Override
        public final Builder brokerAZDistribution(BrokerAZDistribution brokerAZDistribution) {
            this.brokerAZDistribution(brokerAZDistribution == null ? null : brokerAZDistribution.toString());
            return this;
        }

        public final void setBrokerAZDistribution(String brokerAZDistribution) {
            this.brokerAZDistribution = brokerAZDistribution;
        }

        public final Collection<String> getClientSubnets() {
            if (this.clientSubnets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clientSubnets;
        }

        @Override
        public final Builder clientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientSubnets(String ... clientSubnets) {
            this.clientSubnets(Arrays.asList(clientSubnets));
            return this;
        }

        public final void setClientSubnets(Collection<String> clientSubnets) {
            this.clientSubnets = ___listOf__stringCopier.copy(clientSubnets);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = ___listOf__stringCopier.copy(securityGroups);
        }

        public final StorageInfo.Builder getStorageInfo() {
            return this.storageInfo != null ? this.storageInfo.toBuilder() : null;
        }

        @Override
        public final Builder storageInfo(StorageInfo storageInfo) {
            this.storageInfo = storageInfo;
            return this;
        }

        public final void setStorageInfo(StorageInfo.BuilderImpl storageInfo) {
            this.storageInfo = storageInfo != null ? storageInfo.build() : null;
        }

        public BrokerNodeGroupInfo build() {
            return new BrokerNodeGroupInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerNodeGroupInfo> {
        public Builder brokerAZDistribution(String var1);

        public Builder brokerAZDistribution(BrokerAZDistribution var1);

        public Builder clientSubnets(Collection<String> var1);

        public Builder clientSubnets(String ... var1);

        public Builder instanceType(String var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder storageInfo(StorageInfo var1);

        default public Builder storageInfo(Consumer<StorageInfo.Builder> storageInfo) {
            return this.storageInfo((StorageInfo)((StorageInfo.Builder)StorageInfo.builder().applyMutation(storageInfo)).build());
        }
    }
}

