/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.ClusterOperationStep;
import software.amazon.awssdk.services.kafka.model.ErrorInfo;
import software.amazon.awssdk.services.kafka.model.MutableClusterInfo;
import software.amazon.awssdk.services.kafka.model.___listOfClusterOperationStepCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationInfo> {
    private static final SdkField<String> CLIENT_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterOperationInfo.getter(ClusterOperationInfo::clientRequestId)).setter(ClusterOperationInfo.setter(Builder::clientRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestId").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterOperationInfo.getter(ClusterOperationInfo::clusterArn)).setter(ClusterOperationInfo.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ClusterOperationInfo.getter(ClusterOperationInfo::creationTime)).setter(ClusterOperationInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ClusterOperationInfo.getter(ClusterOperationInfo::endTime)).setter(ClusterOperationInfo.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterOperationInfo.getter(ClusterOperationInfo::errorInfo)).setter(ClusterOperationInfo.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationArn)).setter(ClusterOperationInfo.setter(Builder::operationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationState)).setter(ClusterOperationInfo.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<List<ClusterOperationStep>> OPERATION_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationSteps)).setter(ClusterOperationInfo.setter(Builder::operationSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterOperationStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ClusterOperationInfo.getter(ClusterOperationInfo::operationType)).setter(ClusterOperationInfo.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<MutableClusterInfo> SOURCE_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterOperationInfo.getter(ClusterOperationInfo::sourceClusterInfo)).setter(ClusterOperationInfo.setter(Builder::sourceClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceClusterInfo").build()}).build();
    private static final SdkField<MutableClusterInfo> TARGET_CLUSTER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ClusterOperationInfo.getter(ClusterOperationInfo::targetClusterInfo)).setter(ClusterOperationInfo.setter(Builder::targetClusterInfo)).constructor(MutableClusterInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetClusterInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_ID_FIELD, CLUSTER_ARN_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD, ERROR_INFO_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD, OPERATION_STEPS_FIELD, OPERATION_TYPE_FIELD, SOURCE_CLUSTER_INFO_FIELD, TARGET_CLUSTER_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientRequestId;
    private final String clusterArn;
    private final Instant creationTime;
    private final Instant endTime;
    private final ErrorInfo errorInfo;
    private final String operationArn;
    private final String operationState;
    private final List<ClusterOperationStep> operationSteps;
    private final String operationType;
    private final MutableClusterInfo sourceClusterInfo;
    private final MutableClusterInfo targetClusterInfo;

    private ClusterOperationInfo(BuilderImpl builder) {
        this.clientRequestId = builder.clientRequestId;
        this.clusterArn = builder.clusterArn;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.errorInfo = builder.errorInfo;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationSteps = builder.operationSteps;
        this.operationType = builder.operationType;
        this.sourceClusterInfo = builder.sourceClusterInfo;
        this.targetClusterInfo = builder.targetClusterInfo;
    }

    public String clientRequestId() {
        return this.clientRequestId;
    }

    public String clusterArn() {
        return this.clusterArn;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public String operationArn() {
        return this.operationArn;
    }

    public String operationState() {
        return this.operationState;
    }

    public boolean hasOperationSteps() {
        return this.operationSteps != null && !(this.operationSteps instanceof SdkAutoConstructList);
    }

    public List<ClusterOperationStep> operationSteps() {
        return this.operationSteps;
    }

    public String operationType() {
        return this.operationType;
    }

    public MutableClusterInfo sourceClusterInfo() {
        return this.sourceClusterInfo;
    }

    public MutableClusterInfo targetClusterInfo() {
        return this.targetClusterInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceClusterInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationInfo)) {
            return false;
        }
        ClusterOperationInfo other = (ClusterOperationInfo)obj;
        return Objects.equals(this.clientRequestId(), other.clientRequestId()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.operationArn(), other.operationArn()) && Objects.equals(this.operationState(), other.operationState()) && Objects.equals(this.operationSteps(), other.operationSteps()) && Objects.equals(this.operationType(), other.operationType()) && Objects.equals(this.sourceClusterInfo(), other.sourceClusterInfo()) && Objects.equals(this.targetClusterInfo(), other.targetClusterInfo());
    }

    public String toString() {
        return ToString.builder((String)"ClusterOperationInfo").add("ClientRequestId", (Object)this.clientRequestId()).add("ClusterArn", (Object)this.clusterArn()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).add("ErrorInfo", (Object)this.errorInfo()).add("OperationArn", (Object)this.operationArn()).add("OperationState", (Object)this.operationState()).add("OperationSteps", this.operationSteps()).add("OperationType", (Object)this.operationType()).add("SourceClusterInfo", (Object)this.sourceClusterInfo()).add("TargetClusterInfo", (Object)this.targetClusterInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestId": {
                return Optional.ofNullable(clazz.cast(this.clientRequestId()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "OperationArn": {
                return Optional.ofNullable(clazz.cast(this.operationArn()));
            }
            case "OperationState": {
                return Optional.ofNullable(clazz.cast(this.operationState()));
            }
            case "OperationSteps": {
                return Optional.ofNullable(clazz.cast(this.operationSteps()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationType()));
            }
            case "SourceClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.sourceClusterInfo()));
            }
            case "TargetClusterInfo": {
                return Optional.ofNullable(clazz.cast(this.targetClusterInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationInfo, T> g) {
        return obj -> g.apply((ClusterOperationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientRequestId;
        private String clusterArn;
        private Instant creationTime;
        private Instant endTime;
        private ErrorInfo errorInfo;
        private String operationArn;
        private String operationState;
        private List<ClusterOperationStep> operationSteps = DefaultSdkAutoConstructList.getInstance();
        private String operationType;
        private MutableClusterInfo sourceClusterInfo;
        private MutableClusterInfo targetClusterInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationInfo model) {
            this.clientRequestId(model.clientRequestId);
            this.clusterArn(model.clusterArn);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
            this.errorInfo(model.errorInfo);
            this.operationArn(model.operationArn);
            this.operationState(model.operationState);
            this.operationSteps(model.operationSteps);
            this.operationType(model.operationType);
            this.sourceClusterInfo(model.sourceClusterInfo);
            this.targetClusterInfo(model.targetClusterInfo);
        }

        public final String getClientRequestId() {
            return this.clientRequestId;
        }

        @Override
        public final Builder clientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
            return this;
        }

        public final void setClientRequestId(String clientRequestId) {
            this.clientRequestId = clientRequestId;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final String getOperationArn() {
            return this.operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        public final Collection<ClusterOperationStep.Builder> getOperationSteps() {
            return this.operationSteps != null ? (Collection)this.operationSteps.stream().map(ClusterOperationStep::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder operationSteps(Collection<ClusterOperationStep> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copy(operationSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(ClusterOperationStep ... operationSteps) {
            this.operationSteps(Arrays.asList(operationSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... operationSteps) {
            this.operationSteps(Stream.of(operationSteps).map(c -> (ClusterOperationStep)((ClusterOperationStep.Builder)ClusterOperationStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOperationSteps(Collection<ClusterOperationStep.BuilderImpl> operationSteps) {
            this.operationSteps = ___listOfClusterOperationStepCopier.copyFromBuilder(operationSteps);
        }

        public final String getOperationType() {
            return this.operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        public final MutableClusterInfo.Builder getSourceClusterInfo() {
            return this.sourceClusterInfo != null ? this.sourceClusterInfo.toBuilder() : null;
        }

        @Override
        public final Builder sourceClusterInfo(MutableClusterInfo sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo;
            return this;
        }

        public final void setSourceClusterInfo(MutableClusterInfo.BuilderImpl sourceClusterInfo) {
            this.sourceClusterInfo = sourceClusterInfo != null ? sourceClusterInfo.build() : null;
        }

        public final MutableClusterInfo.Builder getTargetClusterInfo() {
            return this.targetClusterInfo != null ? this.targetClusterInfo.toBuilder() : null;
        }

        @Override
        public final Builder targetClusterInfo(MutableClusterInfo targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo;
            return this;
        }

        public final void setTargetClusterInfo(MutableClusterInfo.BuilderImpl targetClusterInfo) {
            this.targetClusterInfo = targetClusterInfo != null ? targetClusterInfo.build() : null;
        }

        public ClusterOperationInfo build() {
            return new ClusterOperationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationInfo> {
        public Builder clientRequestId(String var1);

        public Builder clusterArn(String var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder operationArn(String var1);

        public Builder operationState(String var1);

        public Builder operationSteps(Collection<ClusterOperationStep> var1);

        public Builder operationSteps(ClusterOperationStep ... var1);

        public Builder operationSteps(Consumer<ClusterOperationStep.Builder> ... var1);

        public Builder operationType(String var1);

        public Builder sourceClusterInfo(MutableClusterInfo var1);

        default public Builder sourceClusterInfo(Consumer<MutableClusterInfo.Builder> sourceClusterInfo) {
            return this.sourceClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(sourceClusterInfo)).build());
        }

        public Builder targetClusterInfo(MutableClusterInfo var1);

        default public Builder targetClusterInfo(Consumer<MutableClusterInfo.Builder> targetClusterInfo) {
            return this.targetClusterInfo((MutableClusterInfo)((MutableClusterInfo.Builder)MutableClusterInfo.builder().applyMutation(targetClusterInfo)).build());
        }
    }
}

