/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo;
import software.amazon.awssdk.services.kafka.model.ConfigurationInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoring;
import software.amazon.awssdk.services.kafka.model.___listOfBrokerEBSVolumeInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MutableClusterInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MutableClusterInfo> {
    private static final SdkField<List<BrokerEBSVolumeInfo>> BROKER_EBS_VOLUME_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MutableClusterInfo.getter(MutableClusterInfo::brokerEBSVolumeInfo)).setter(MutableClusterInfo.setter(Builder::brokerEBSVolumeInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerEBSVolumeInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BrokerEBSVolumeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ConfigurationInfo> CONFIGURATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MutableClusterInfo.getter(MutableClusterInfo::configurationInfo)).setter(MutableClusterInfo.setter(Builder::configurationInfo)).constructor(ConfigurationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(MutableClusterInfo.getter(MutableClusterInfo::numberOfBrokerNodes)).setter(MutableClusterInfo.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MutableClusterInfo.getter(MutableClusterInfo::enhancedMonitoringAsString)).setter(MutableClusterInfo.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MutableClusterInfo.getter(MutableClusterInfo::openMonitoring)).setter(MutableClusterInfo.setter(Builder::openMonitoring)).constructor(OpenMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(MutableClusterInfo.getter(MutableClusterInfo::loggingInfo)).setter(MutableClusterInfo.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_EBS_VOLUME_INFO_FIELD, CONFIGURATION_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo;
    private final ConfigurationInfo configurationInfo;
    private final Integer numberOfBrokerNodes;
    private final String enhancedMonitoring;
    private final OpenMonitoring openMonitoring;
    private final LoggingInfo loggingInfo;

    private MutableClusterInfo(BuilderImpl builder) {
        this.brokerEBSVolumeInfo = builder.brokerEBSVolumeInfo;
        this.configurationInfo = builder.configurationInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
    }

    public boolean hasBrokerEBSVolumeInfo() {
        return this.brokerEBSVolumeInfo != null && !(this.brokerEBSVolumeInfo instanceof SdkAutoConstructList);
    }

    public List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo() {
        return this.brokerEBSVolumeInfo;
    }

    public ConfigurationInfo configurationInfo() {
        return this.configurationInfo;
    }

    public Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public OpenMonitoring openMonitoring() {
        return this.openMonitoring;
    }

    public LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerEBSVolumeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MutableClusterInfo)) {
            return false;
        }
        MutableClusterInfo other = (MutableClusterInfo)obj;
        return Objects.equals(this.brokerEBSVolumeInfo(), other.brokerEBSVolumeInfo()) && Objects.equals(this.configurationInfo(), other.configurationInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo());
    }

    public String toString() {
        return ToString.builder((String)"MutableClusterInfo").add("BrokerEBSVolumeInfo", this.brokerEBSVolumeInfo()).add("ConfigurationInfo", (Object)this.configurationInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BrokerEBSVolumeInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerEBSVolumeInfo()));
            }
            case "ConfigurationInfo": {
                return Optional.ofNullable(clazz.cast(this.configurationInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MutableClusterInfo, T> g) {
        return obj -> g.apply((MutableClusterInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<BrokerEBSVolumeInfo> brokerEBSVolumeInfo = DefaultSdkAutoConstructList.getInstance();
        private ConfigurationInfo configurationInfo;
        private Integer numberOfBrokerNodes;
        private String enhancedMonitoring;
        private OpenMonitoring openMonitoring;
        private LoggingInfo loggingInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(MutableClusterInfo model) {
            this.brokerEBSVolumeInfo(model.brokerEBSVolumeInfo);
            this.configurationInfo(model.configurationInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
        }

        public final Collection<BrokerEBSVolumeInfo.Builder> getBrokerEBSVolumeInfo() {
            return this.brokerEBSVolumeInfo != null ? (Collection)this.brokerEBSVolumeInfo.stream().map(BrokerEBSVolumeInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copy(brokerEBSVolumeInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo ... brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo(Arrays.asList(brokerEBSVolumeInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder> ... brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo(Stream.of(brokerEBSVolumeInfo).map(c -> (BrokerEBSVolumeInfo)((BrokerEBSVolumeInfo.Builder)BrokerEBSVolumeInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBrokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo.BuilderImpl> brokerEBSVolumeInfo) {
            this.brokerEBSVolumeInfo = ___listOfBrokerEBSVolumeInfoCopier.copyFromBuilder(brokerEBSVolumeInfo);
        }

        public final ConfigurationInfo.Builder getConfigurationInfo() {
            return this.configurationInfo != null ? this.configurationInfo.toBuilder() : null;
        }

        @Override
        public final Builder configurationInfo(ConfigurationInfo configurationInfo) {
            this.configurationInfo = configurationInfo;
            return this;
        }

        public final void setConfigurationInfo(ConfigurationInfo.BuilderImpl configurationInfo) {
            this.configurationInfo = configurationInfo != null ? configurationInfo.build() : null;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public MutableClusterInfo build() {
            return new MutableClusterInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MutableClusterInfo> {
        public Builder brokerEBSVolumeInfo(Collection<BrokerEBSVolumeInfo> var1);

        public Builder brokerEBSVolumeInfo(BrokerEBSVolumeInfo ... var1);

        public Builder brokerEBSVolumeInfo(Consumer<BrokerEBSVolumeInfo.Builder> ... var1);

        public Builder configurationInfo(ConfigurationInfo var1);

        default public Builder configurationInfo(Consumer<ConfigurationInfo.Builder> configurationInfo) {
            return this.configurationInfo((ConfigurationInfo)((ConfigurationInfo.Builder)ConfigurationInfo.builder().applyMutation(configurationInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoring var1);

        default public Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoring)((OpenMonitoring.Builder)OpenMonitoring.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }
    }
}

