/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.CompositionState;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationSummaryListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositionSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CompositionSummary.getter(CompositionSummary::arn)).setter(CompositionSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(CompositionSummary.getter(CompositionSummary::stageArn)).setter(CompositionSummary.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<List<DestinationSummary>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(CompositionSummary.getter(CompositionSummary::destinations)).setter(CompositionSummary.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(CompositionSummary.getter(CompositionSummary::stateAsString)).setter(CompositionSummary.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CompositionSummary.getter(CompositionSummary::tags)).setter(CompositionSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(CompositionSummary.getter(CompositionSummary::startTime)).setter(CompositionSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(CompositionSummary.getter(CompositionSummary::endTime)).setter(CompositionSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STAGE_ARN_FIELD, DESTINATIONS_FIELD, STATE_FIELD, TAGS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompositionSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String stageArn;
    private final List<DestinationSummary> destinations;
    private final String state;
    private final Map<String, String> tags;
    private final Instant startTime;
    private final Instant endTime;

    private CompositionSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.stageArn = builder.stageArn;
        this.destinations = builder.destinations;
        this.state = builder.state;
        this.tags = builder.tags;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String arn() {
        return this.arn;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<DestinationSummary> destinations() {
        return this.destinations;
    }

    public final CompositionState state() {
        return CompositionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositionSummary)) {
            return false;
        }
        CompositionSummary other = (CompositionSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.stageArn(), other.stageArn()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"CompositionSummary").add("Arn", (Object)this.arn()).add("StageArn", (Object)this.stageArn()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("state", STATE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositionSummary, T> g) {
        return obj -> g.apply((CompositionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String stageArn;
        private List<DestinationSummary> destinations = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositionSummary model) {
            this.arn(model.arn);
            this.stageArn(model.stageArn);
            this.destinations(model.destinations);
            this.state(model.state);
            this.tags(model.tags);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final List<DestinationSummary.Builder> getDestinations() {
            List<DestinationSummary.Builder> result = DestinationSummaryListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<DestinationSummary.BuilderImpl> destinations) {
            this.destinations = DestinationSummaryListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<DestinationSummary> destinations) {
            this.destinations = DestinationSummaryListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationSummary ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationSummary.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (DestinationSummary)((DestinationSummary.Builder)DestinationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CompositionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public CompositionSummary build() {
            return new CompositionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositionSummary> {
        public Builder arn(String var1);

        public Builder stageArn(String var1);

        public Builder destinations(Collection<DestinationSummary> var1);

        public Builder destinations(DestinationSummary ... var1);

        public Builder destinations(Consumer<DestinationSummary.Builder> ... var1);

        public Builder state(String var1);

        public Builder state(CompositionState var1);

        public Builder tags(Map<String, String> var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

