/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationDetail;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Destination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Destination> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Destination.getter(Destination::id)).setter(Destination.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Destination.getter(Destination::stateAsString)).setter(Destination.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Destination.getter(Destination::startTime)).setter(Destination.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(Destination.getter(Destination::endTime)).setter(Destination.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DestinationConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(Destination.getter(Destination::configuration)).setter(Destination.setter(Builder::configuration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<DestinationDetail> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detail").getter(Destination.getter(Destination::detail)).setter(Destination.setter(Builder::detail)).constructor(DestinationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD, CONFIGURATION_FIELD, DETAIL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Destination.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String state;
    private final Instant startTime;
    private final Instant endTime;
    private final DestinationConfiguration configuration;
    private final DestinationDetail detail;

    private Destination(BuilderImpl builder) {
        this.id = builder.id;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.configuration = builder.configuration;
        this.detail = builder.detail;
    }

    public final String id() {
        return this.id;
    }

    public final DestinationState state() {
        return DestinationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final DestinationConfiguration configuration() {
        return this.configuration;
    }

    public final DestinationDetail detail() {
        return this.detail;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Destination)) {
            return false;
        }
        Destination other = (Destination)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.detail(), other.detail());
    }

    public final String toString() {
        return ToString.builder((String)"Destination").add("Id", (Object)this.id()).add("State", (Object)this.stateAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Configuration", (Object)this.configuration()).add("Detail", (Object)this.detail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("state", STATE_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("detail", DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Destination, T> g) {
        return obj -> g.apply((Destination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String state;
        private Instant startTime;
        private Instant endTime;
        private DestinationConfiguration configuration;
        private DestinationDetail detail;

        private BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.id(model.id);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.configuration(model.configuration);
            this.detail(model.detail);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(DestinationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final DestinationConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(DestinationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DestinationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final DestinationDetail.Builder getDetail() {
            return this.detail != null ? this.detail.toBuilder() : null;
        }

        public final void setDetail(DestinationDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(DestinationDetail detail) {
            this.detail = detail;
            return this;
        }

        public Destination build() {
            return new Destination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Destination> {
        public Builder id(String var1);

        public Builder state(String var1);

        public Builder state(DestinationState var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder configuration(DestinationConfiguration var1);

        default public Builder configuration(Consumer<DestinationConfiguration.Builder> configuration) {
            return this.configuration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder detail(DestinationDetail var1);

        default public Builder detail(Consumer<DestinationDetail.Builder> detail) {
            return this.detail((DestinationDetail)((DestinationDetail.Builder)DestinationDetail.builder().applyMutation(detail)).build());
        }
    }
}

