/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.DestinationConfigurationListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.LayoutConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCompositionRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, StartCompositionRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(StartCompositionRequest.getter(StartCompositionRequest::stageArn)).setter(StartCompositionRequest.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<String> IDEMPOTENCY_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("idempotencyToken").getter(StartCompositionRequest.getter(StartCompositionRequest::idempotencyToken)).setter(StartCompositionRequest.setter(Builder::idempotencyToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idempotencyToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<LayoutConfiguration> LAYOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("layout").getter(StartCompositionRequest.getter(StartCompositionRequest::layout)).setter(StartCompositionRequest.setter(Builder::layout)).constructor(LayoutConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layout").build()}).build();
    private static final SdkField<List<DestinationConfiguration>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("destinations").getter(StartCompositionRequest.getter(StartCompositionRequest::destinations)).setter(StartCompositionRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(StartCompositionRequest.getter(StartCompositionRequest::tags)).setter(StartCompositionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD, IDEMPOTENCY_TOKEN_FIELD, LAYOUT_FIELD, DESTINATIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCompositionRequest.memberNameToFieldInitializer();
    private final String stageArn;
    private final String idempotencyToken;
    private final LayoutConfiguration layout;
    private final List<DestinationConfiguration> destinations;
    private final Map<String, String> tags;

    private StartCompositionRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.idempotencyToken = builder.idempotencyToken;
        this.layout = builder.layout;
        this.destinations = builder.destinations;
        this.tags = builder.tags;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final String idempotencyToken() {
        return this.idempotencyToken;
    }

    public final LayoutConfiguration layout() {
        return this.layout;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<DestinationConfiguration> destinations() {
        return this.destinations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.idempotencyToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.layout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCompositionRequest)) {
            return false;
        }
        StartCompositionRequest other = (StartCompositionRequest)((Object)obj);
        return Objects.equals(this.stageArn(), other.stageArn()) && Objects.equals(this.idempotencyToken(), other.idempotencyToken()) && Objects.equals(this.layout(), other.layout()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"StartCompositionRequest").add("StageArn", (Object)this.stageArn()).add("IdempotencyToken", (Object)this.idempotencyToken()).add("Layout", (Object)this.layout()).add("Destinations", this.hasDestinations() ? this.destinations() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "idempotencyToken": {
                return Optional.ofNullable(clazz.cast(this.idempotencyToken()));
            }
            case "layout": {
                return Optional.ofNullable(clazz.cast(this.layout()));
            }
            case "destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stageArn", STAGE_ARN_FIELD);
        map.put("idempotencyToken", IDEMPOTENCY_TOKEN_FIELD);
        map.put("layout", LAYOUT_FIELD);
        map.put("destinations", DESTINATIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCompositionRequest, T> g) {
        return obj -> g.apply((StartCompositionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String stageArn;
        private String idempotencyToken;
        private LayoutConfiguration layout;
        private List<DestinationConfiguration> destinations = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartCompositionRequest model) {
            super(model);
            this.stageArn(model.stageArn);
            this.idempotencyToken(model.idempotencyToken);
            this.layout(model.layout);
            this.destinations(model.destinations);
            this.tags(model.tags);
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final String getIdempotencyToken() {
            return this.idempotencyToken;
        }

        public final void setIdempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
        }

        @Override
        public final Builder idempotencyToken(String idempotencyToken) {
            this.idempotencyToken = idempotencyToken;
            return this;
        }

        public final LayoutConfiguration.Builder getLayout() {
            return this.layout != null ? this.layout.toBuilder() : null;
        }

        public final void setLayout(LayoutConfiguration.BuilderImpl layout) {
            this.layout = layout != null ? layout.build() : null;
        }

        @Override
        public final Builder layout(LayoutConfiguration layout) {
            this.layout = layout;
            return this;
        }

        public final List<DestinationConfiguration.Builder> getDestinations() {
            List<DestinationConfiguration.Builder> result = DestinationConfigurationListCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<DestinationConfiguration.BuilderImpl> destinations) {
            this.destinations = DestinationConfigurationListCopier.copyFromBuilder(destinations);
        }

        @Override
        public final Builder destinations(Collection<DestinationConfiguration> destinations) {
            this.destinations = DestinationConfigurationListCopier.copy(destinations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(DestinationConfiguration ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinations(Consumer<DestinationConfiguration.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCompositionRequest build() {
            return new StartCompositionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCompositionRequest> {
        public Builder stageArn(String var1);

        public Builder idempotencyToken(String var1);

        public Builder layout(LayoutConfiguration var1);

        default public Builder layout(Consumer<LayoutConfiguration.Builder> layout) {
            return this.layout((LayoutConfiguration)((LayoutConfiguration.Builder)LayoutConfiguration.builder().applyMutation(layout)).build());
        }

        public Builder destinations(Collection<DestinationConfiguration> var1);

        public Builder destinations(DestinationConfiguration ... var1);

        public Builder destinations(Consumer<DestinationConfiguration.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

