/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.ThumbnailStorageType;
import software.amazon.awssdk.services.ivsrealtime.model.ThumbnailStorageTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositionThumbnailConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositionThumbnailConfiguration> {
    private static final SdkField<Integer> TARGET_INTERVAL_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetIntervalSeconds").getter(CompositionThumbnailConfiguration.getter(CompositionThumbnailConfiguration::targetIntervalSeconds)).setter(CompositionThumbnailConfiguration.setter(Builder::targetIntervalSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIntervalSeconds").build()}).build();
    private static final SdkField<List<String>> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("storage").getter(CompositionThumbnailConfiguration.getter(CompositionThumbnailConfiguration::storageAsStrings)).setter(CompositionThumbnailConfiguration.setter(Builder::storageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_INTERVAL_SECONDS_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("targetIntervalSeconds", TARGET_INTERVAL_SECONDS_FIELD);
            this.put("storage", STORAGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer targetIntervalSeconds;
    private final List<String> storage;

    private CompositionThumbnailConfiguration(BuilderImpl builder) {
        this.targetIntervalSeconds = builder.targetIntervalSeconds;
        this.storage = builder.storage;
    }

    public final Integer targetIntervalSeconds() {
        return this.targetIntervalSeconds;
    }

    public final List<ThumbnailStorageType> storage() {
        return ThumbnailStorageTypeListCopier.copyStringToEnum(this.storage);
    }

    public final boolean hasStorage() {
        return this.storage != null && !(this.storage instanceof SdkAutoConstructList);
    }

    public final List<String> storageAsStrings() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIntervalSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorage() ? this.storageAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositionThumbnailConfiguration)) {
            return false;
        }
        CompositionThumbnailConfiguration other = (CompositionThumbnailConfiguration)obj;
        return Objects.equals(this.targetIntervalSeconds(), other.targetIntervalSeconds()) && this.hasStorage() == other.hasStorage() && Objects.equals(this.storageAsStrings(), other.storageAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CompositionThumbnailConfiguration").add("TargetIntervalSeconds", (Object)this.targetIntervalSeconds()).add("Storage", this.hasStorage() ? this.storageAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetIntervalSeconds": {
                return Optional.ofNullable(clazz.cast(this.targetIntervalSeconds()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storageAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CompositionThumbnailConfiguration, T> g) {
        return obj -> g.apply((CompositionThumbnailConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer targetIntervalSeconds;
        private List<String> storage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompositionThumbnailConfiguration model) {
            this.targetIntervalSeconds(model.targetIntervalSeconds);
            this.storageWithStrings(model.storage);
        }

        public final Integer getTargetIntervalSeconds() {
            return this.targetIntervalSeconds;
        }

        public final void setTargetIntervalSeconds(Integer targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
        }

        @Override
        public final Builder targetIntervalSeconds(Integer targetIntervalSeconds) {
            this.targetIntervalSeconds = targetIntervalSeconds;
            return this;
        }

        public final Collection<String> getStorage() {
            if (this.storage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.storage;
        }

        public final void setStorage(Collection<String> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copy(storage);
        }

        @Override
        public final Builder storageWithStrings(Collection<String> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageWithStrings(String ... storage) {
            this.storageWithStrings(Arrays.asList(storage));
            return this;
        }

        @Override
        public final Builder storage(Collection<ThumbnailStorageType> storage) {
            this.storage = ThumbnailStorageTypeListCopier.copyEnumToString(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ThumbnailStorageType ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        public CompositionThumbnailConfiguration build() {
            return new CompositionThumbnailConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositionThumbnailConfiguration> {
        public Builder targetIntervalSeconds(Integer var1);

        public Builder storageWithStrings(Collection<String> var1);

        public Builder storageWithStrings(String ... var1);

        public Builder storage(Collection<ThumbnailStorageType> var1);

        public Builder storage(ThumbnailStorageType ... var1);
    }
}

