/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStorageConfigurationsResponse;

public class ListStorageConfigurationsPublisher
implements SdkPublisher<ListStorageConfigurationsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListStorageConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStorageConfigurationsPublisher(IvsRealTimeAsyncClient client, ListStorageConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStorageConfigurationsPublisher(IvsRealTimeAsyncClient client, ListStorageConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStorageConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStorageConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListStorageConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListStorageConfigurationsResponse> {
        private ListStorageConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListStorageConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStorageConfigurationsResponse> nextPage(ListStorageConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListStorageConfigurationsPublisher.this.client.listStorageConfigurations(ListStorageConfigurationsPublisher.this.firstRequest);
            }
            return ListStorageConfigurationsPublisher.this.client.listStorageConfigurations((ListStorageConfigurationsRequest)((Object)ListStorageConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

