/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.EncoderConfigurationSummary;
import software.amazon.awssdk.services.ivsrealtime.model.EncoderConfigurationSummaryListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEncoderConfigurationsResponse
extends IvsRealTimeResponse
implements ToCopyableBuilder<Builder, ListEncoderConfigurationsResponse> {
    private static final SdkField<List<EncoderConfigurationSummary>> ENCODER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("encoderConfigurations").getter(ListEncoderConfigurationsResponse.getter(ListEncoderConfigurationsResponse::encoderConfigurations)).setter(ListEncoderConfigurationsResponse.setter(Builder::encoderConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EncoderConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEncoderConfigurationsResponse.getter(ListEncoderConfigurationsResponse::nextToken)).setter(ListEncoderConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCODER_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("encoderConfigurations", ENCODER_CONFIGURATIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<EncoderConfigurationSummary> encoderConfigurations;
    private final String nextToken;

    private ListEncoderConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.encoderConfigurations = builder.encoderConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEncoderConfigurations() {
        return this.encoderConfigurations != null && !(this.encoderConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EncoderConfigurationSummary> encoderConfigurations() {
        return this.encoderConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncoderConfigurations() ? this.encoderConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEncoderConfigurationsResponse)) {
            return false;
        }
        ListEncoderConfigurationsResponse other = (ListEncoderConfigurationsResponse)((Object)obj);
        return this.hasEncoderConfigurations() == other.hasEncoderConfigurations() && Objects.equals(this.encoderConfigurations(), other.encoderConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEncoderConfigurationsResponse").add("EncoderConfigurations", this.hasEncoderConfigurations() ? this.encoderConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "encoderConfigurations": {
                return Optional.ofNullable(clazz.cast(this.encoderConfigurations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListEncoderConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEncoderConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeResponse.BuilderImpl
    implements Builder {
        private List<EncoderConfigurationSummary> encoderConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEncoderConfigurationsResponse model) {
            super(model);
            this.encoderConfigurations(model.encoderConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<EncoderConfigurationSummary.Builder> getEncoderConfigurations() {
            List<EncoderConfigurationSummary.Builder> result = EncoderConfigurationSummaryListCopier.copyToBuilder(this.encoderConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEncoderConfigurations(Collection<EncoderConfigurationSummary.BuilderImpl> encoderConfigurations) {
            this.encoderConfigurations = EncoderConfigurationSummaryListCopier.copyFromBuilder(encoderConfigurations);
        }

        @Override
        public final Builder encoderConfigurations(Collection<EncoderConfigurationSummary> encoderConfigurations) {
            this.encoderConfigurations = EncoderConfigurationSummaryListCopier.copy(encoderConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encoderConfigurations(EncoderConfigurationSummary ... encoderConfigurations) {
            this.encoderConfigurations(Arrays.asList(encoderConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encoderConfigurations(Consumer<EncoderConfigurationSummary.Builder> ... encoderConfigurations) {
            this.encoderConfigurations(Stream.of(encoderConfigurations).map(c -> (EncoderConfigurationSummary)((EncoderConfigurationSummary.Builder)EncoderConfigurationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEncoderConfigurationsResponse build() {
            return new ListEncoderConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IvsRealTimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEncoderConfigurationsResponse> {
        public Builder encoderConfigurations(Collection<EncoderConfigurationSummary> var1);

        public Builder encoderConfigurations(EncoderConfigurationSummary ... var1);

        public Builder encoderConfigurations(Consumer<EncoderConfigurationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

