/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenAttributesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapabilitiesCopier;
import software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateParticipantTokenRequest
extends IvsRealTimeRequest
implements ToCopyableBuilder<Builder, CreateParticipantTokenRequest> {
    private static final SdkField<String> STAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stageArn").getter(CreateParticipantTokenRequest.getter(CreateParticipantTokenRequest::stageArn)).setter(CreateParticipantTokenRequest.setter(Builder::stageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stageArn").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("duration").getter(CreateParticipantTokenRequest.getter(CreateParticipantTokenRequest::duration)).setter(CreateParticipantTokenRequest.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userId").getter(CreateParticipantTokenRequest.getter(CreateParticipantTokenRequest::userId)).setter(CreateParticipantTokenRequest.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userId").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("attributes").getter(CreateParticipantTokenRequest.getter(CreateParticipantTokenRequest::attributes)).setter(CreateParticipantTokenRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("capabilities").getter(CreateParticipantTokenRequest.getter(CreateParticipantTokenRequest::capabilitiesAsStrings)).setter(CreateParticipantTokenRequest.setter(Builder::capabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STAGE_ARN_FIELD, DURATION_FIELD, USER_ID_FIELD, ATTRIBUTES_FIELD, CAPABILITIES_FIELD));
    private final String stageArn;
    private final Integer duration;
    private final String userId;
    private final Map<String, String> attributes;
    private final List<String> capabilities;

    private CreateParticipantTokenRequest(BuilderImpl builder) {
        super(builder);
        this.stageArn = builder.stageArn;
        this.duration = builder.duration;
        this.userId = builder.userId;
        this.attributes = builder.attributes;
        this.capabilities = builder.capabilities;
    }

    public final String stageArn() {
        return this.stageArn;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final String userId() {
        return this.userId;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final List<ParticipantTokenCapability> capabilities() {
        return ParticipantTokenCapabilitiesCopier.copyStringToEnum(this.capabilities);
    }

    public final boolean hasCapabilities() {
        return this.capabilities != null && !(this.capabilities instanceof SdkAutoConstructList);
    }

    public final List<String> capabilitiesAsStrings() {
        return this.capabilities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapabilities() ? this.capabilitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParticipantTokenRequest)) {
            return false;
        }
        CreateParticipantTokenRequest other = (CreateParticipantTokenRequest)((Object)obj);
        return Objects.equals(this.stageArn(), other.stageArn()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.userId(), other.userId()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && this.hasCapabilities() == other.hasCapabilities() && Objects.equals(this.capabilitiesAsStrings(), other.capabilitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateParticipantTokenRequest").add("StageArn", (Object)this.stageArn()).add("Duration", (Object)this.duration()).add("UserId", (Object)this.userId()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Capabilities", this.hasCapabilities() ? this.capabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stageArn": {
                return Optional.ofNullable(clazz.cast(this.stageArn()));
            }
            case "duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "userId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "capabilities": {
                return Optional.ofNullable(clazz.cast(this.capabilitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateParticipantTokenRequest, T> g) {
        return obj -> g.apply((CreateParticipantTokenRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRealTimeRequest.BuilderImpl
    implements Builder {
        private String stageArn;
        private Integer duration;
        private String userId;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParticipantTokenRequest model) {
            super(model);
            this.stageArn(model.stageArn);
            this.duration(model.duration);
            this.userId(model.userId);
            this.attributes(model.attributes);
            this.capabilitiesWithStrings(model.capabilities);
        }

        public final String getStageArn() {
            return this.stageArn;
        }

        public final void setStageArn(String stageArn) {
            this.stageArn = stageArn;
        }

        @Override
        public final Builder stageArn(String stageArn) {
            this.stageArn = stageArn;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ParticipantTokenAttributesCopier.copy(attributes);
            return this;
        }

        public final Collection<String> getCapabilities() {
            if (this.capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
        }

        @Override
        public final Builder capabilitiesWithStrings(Collection<String> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilitiesWithStrings(String ... capabilities) {
            this.capabilitiesWithStrings(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public final Builder capabilities(Collection<ParticipantTokenCapability> capabilities) {
            this.capabilities = ParticipantTokenCapabilitiesCopier.copyEnumToString(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(ParticipantTokenCapability ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateParticipantTokenRequest build() {
            return new CreateParticipantTokenRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRealTimeRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateParticipantTokenRequest> {
        public Builder stageArn(String var1);

        public Builder duration(Integer var1);

        public Builder userId(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder capabilitiesWithStrings(Collection<String> var1);

        public Builder capabilitiesWithStrings(String ... var1);

        public Builder capabilities(Collection<ParticipantTokenCapability> var1);

        public Builder capabilities(ParticipantTokenCapability ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

