/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivsrealtime.model.EncoderConfigurationArnListCopier;
import software.amazon.awssdk.services.ivsrealtime.model.RecordingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationConfiguration> {
    private static final SdkField<String> STORAGE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageConfigurationArn").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::storageConfigurationArn)).setter(S3DestinationConfiguration.setter(Builder::storageConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfigurationArn").build()}).build();
    private static final SdkField<List<String>> ENCODER_CONFIGURATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("encoderConfigurationArns").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::encoderConfigurationArns)).setter(S3DestinationConfiguration.setter(Builder::encoderConfigurationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoderConfigurationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<RecordingConfiguration> RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recordingConfiguration").getter(S3DestinationConfiguration.getter(S3DestinationConfiguration::recordingConfiguration)).setter(S3DestinationConfiguration.setter(Builder::recordingConfiguration)).constructor(RecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_CONFIGURATION_ARN_FIELD, ENCODER_CONFIGURATION_ARNS_FIELD, RECORDING_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String storageConfigurationArn;
    private final List<String> encoderConfigurationArns;
    private final RecordingConfiguration recordingConfiguration;

    private S3DestinationConfiguration(BuilderImpl builder) {
        this.storageConfigurationArn = builder.storageConfigurationArn;
        this.encoderConfigurationArns = builder.encoderConfigurationArns;
        this.recordingConfiguration = builder.recordingConfiguration;
    }

    public final String storageConfigurationArn() {
        return this.storageConfigurationArn;
    }

    public final boolean hasEncoderConfigurationArns() {
        return this.encoderConfigurationArns != null && !(this.encoderConfigurationArns instanceof SdkAutoConstructList);
    }

    public final List<String> encoderConfigurationArns() {
        return this.encoderConfigurationArns;
    }

    public final RecordingConfiguration recordingConfiguration() {
        return this.recordingConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEncoderConfigurationArns() ? this.encoderConfigurationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationConfiguration)) {
            return false;
        }
        S3DestinationConfiguration other = (S3DestinationConfiguration)obj;
        return Objects.equals(this.storageConfigurationArn(), other.storageConfigurationArn()) && this.hasEncoderConfigurationArns() == other.hasEncoderConfigurationArns() && Objects.equals(this.encoderConfigurationArns(), other.encoderConfigurationArns()) && Objects.equals(this.recordingConfiguration(), other.recordingConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationConfiguration").add("StorageConfigurationArn", (Object)this.storageConfigurationArn()).add("EncoderConfigurationArns", this.hasEncoderConfigurationArns() ? this.encoderConfigurationArns() : null).add("RecordingConfiguration", (Object)this.recordingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.storageConfigurationArn()));
            }
            case "encoderConfigurationArns": {
                return Optional.ofNullable(clazz.cast(this.encoderConfigurationArns()));
            }
            case "recordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.recordingConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationConfiguration, T> g) {
        return obj -> g.apply((S3DestinationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageConfigurationArn;
        private List<String> encoderConfigurationArns = DefaultSdkAutoConstructList.getInstance();
        private RecordingConfiguration recordingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationConfiguration model) {
            this.storageConfigurationArn(model.storageConfigurationArn);
            this.encoderConfigurationArns(model.encoderConfigurationArns);
            this.recordingConfiguration(model.recordingConfiguration);
        }

        public final String getStorageConfigurationArn() {
            return this.storageConfigurationArn;
        }

        public final void setStorageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
        }

        @Override
        public final Builder storageConfigurationArn(String storageConfigurationArn) {
            this.storageConfigurationArn = storageConfigurationArn;
            return this;
        }

        public final Collection<String> getEncoderConfigurationArns() {
            if (this.encoderConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.encoderConfigurationArns;
        }

        public final void setEncoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
        }

        @Override
        public final Builder encoderConfigurationArns(Collection<String> encoderConfigurationArns) {
            this.encoderConfigurationArns = EncoderConfigurationArnListCopier.copy(encoderConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder encoderConfigurationArns(String ... encoderConfigurationArns) {
            this.encoderConfigurationArns(Arrays.asList(encoderConfigurationArns));
            return this;
        }

        public final RecordingConfiguration.Builder getRecordingConfiguration() {
            return this.recordingConfiguration != null ? this.recordingConfiguration.toBuilder() : null;
        }

        public final void setRecordingConfiguration(RecordingConfiguration.BuilderImpl recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration != null ? recordingConfiguration.build() : null;
        }

        @Override
        public final Builder recordingConfiguration(RecordingConfiguration recordingConfiguration) {
            this.recordingConfiguration = recordingConfiguration;
            return this;
        }

        public S3DestinationConfiguration build() {
            return new S3DestinationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationConfiguration> {
        public Builder storageConfigurationArn(String var1);

        public Builder encoderConfigurationArns(Collection<String> var1);

        public Builder encoderConfigurationArns(String ... var1);

        public Builder recordingConfiguration(RecordingConfiguration var1);

        default public Builder recordingConfiguration(Consumer<RecordingConfiguration.Builder> recordingConfiguration) {
            return this.recordingConfiguration((RecordingConfiguration)((RecordingConfiguration.Builder)RecordingConfiguration.builder().applyMutation(recordingConfiguration)).build());
        }
    }
}

