/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeServiceClientConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.AccessDeniedException;
import software.amazon.awssdk.services.ivsrealtime.model.ConflictException;
import software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DeleteStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest;
import software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest;
import software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse;
import software.amazon.awssdk.services.ivsrealtime.model.InternalServerException;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeException;
import software.amazon.awssdk.services.ivsrealtime.model.IvsRealTimeRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.PendingVerificationException;
import software.amazon.awssdk.services.ivsrealtime.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ivsrealtime.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ivsrealtime.model.TagResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.TagResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.UntagResourceRequest;
import software.amazon.awssdk.services.ivsrealtime.model.UntagResourceResponse;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest;
import software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse;
import software.amazon.awssdk.services.ivsrealtime.model.ValidationException;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantEventsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListParticipantsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListStageSessionsPublisher;
import software.amazon.awssdk.services.ivsrealtime.paginators.ListStagesPublisher;
import software.amazon.awssdk.services.ivsrealtime.transform.CreateParticipantTokenRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.CreateStageRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.DeleteStageRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.DisconnectParticipantRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.GetParticipantRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.GetStageRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.GetStageSessionRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.ListParticipantEventsRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.ListParticipantsRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.ListStageSessionsRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.ListStagesRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ivsrealtime.transform.UpdateStageRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultIvsRealTimeAsyncClient
implements IvsRealTimeAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIvsRealTimeAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final IvsRealTimeServiceClientConfiguration serviceClientConfiguration;

    protected DefaultIvsRealTimeAsyncClient(IvsRealTimeServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateParticipantTokenResponse> createParticipantToken(CreateParticipantTokenRequest createParticipantTokenRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createParticipantTokenRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateParticipantToken");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateParticipantTokenResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateParticipantToken").withMarshaller((Marshaller)new CreateParticipantTokenRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createParticipantTokenRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$createParticipantToken$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$createParticipantToken$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStageResponse> createStage(CreateStageRequest createStageRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, createStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStage").withMarshaller((Marshaller)new CreateStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$createStage$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$createStage$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStageResponse> deleteStage(DeleteStageRequest deleteStageRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStage").withMarshaller((Marshaller)new DeleteStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$deleteStage$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$deleteStage$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisconnectParticipantResponse> disconnectParticipant(DisconnectParticipantRequest disconnectParticipantRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, disconnectParticipantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisconnectParticipant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisconnectParticipantResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisconnectParticipant").withMarshaller((Marshaller)new DisconnectParticipantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disconnectParticipantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$disconnectParticipant$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$disconnectParticipant$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetParticipantResponse> getParticipant(GetParticipantRequest getParticipantRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getParticipantRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetParticipant");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetParticipantResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetParticipant").withMarshaller((Marshaller)new GetParticipantRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getParticipantRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$getParticipant$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$getParticipant$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStageResponse> getStage(GetStageRequest getStageRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStage").withMarshaller((Marshaller)new GetStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$getStage$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$getStage$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetStageSessionResponse> getStageSession(GetStageSessionRequest getStageSessionRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, getStageSessionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStageSession");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStageSessionResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStageSession").withMarshaller((Marshaller)new GetStageSessionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getStageSessionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$getStageSession$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$getStageSession$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListParticipantEventsResponse> listParticipantEvents(ListParticipantEventsRequest listParticipantEventsRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listParticipantEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListParticipantEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParticipantEventsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParticipantEvents").withMarshaller((Marshaller)new ListParticipantEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listParticipantEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$listParticipantEvents$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$listParticipantEvents$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListParticipantEventsPublisher listParticipantEventsPaginator(ListParticipantEventsRequest listParticipantEventsRequest) {
        return new ListParticipantEventsPublisher(this, this.applyPaginatorUserAgent(listParticipantEventsRequest));
    }

    @Override
    public CompletableFuture<ListParticipantsResponse> listParticipants(ListParticipantsRequest listParticipantsRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listParticipantsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListParticipants");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListParticipantsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListParticipants").withMarshaller((Marshaller)new ListParticipantsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listParticipantsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$listParticipants$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$listParticipants$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListParticipantsPublisher listParticipantsPaginator(ListParticipantsRequest listParticipantsRequest) {
        return new ListParticipantsPublisher(this, this.applyPaginatorUserAgent(listParticipantsRequest));
    }

    @Override
    public CompletableFuture<ListStageSessionsResponse> listStageSessions(ListStageSessionsRequest listStageSessionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStageSessionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStageSessions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStageSessionsResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStageSessions").withMarshaller((Marshaller)new ListStageSessionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStageSessionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$listStageSessions$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$listStageSessions$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListStageSessionsPublisher listStageSessionsPaginator(ListStageSessionsRequest listStageSessionsRequest) {
        return new ListStageSessionsPublisher(this, this.applyPaginatorUserAgent(listStageSessionsRequest));
    }

    @Override
    public CompletableFuture<ListStagesResponse> listStages(ListStagesRequest listStagesRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listStagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStages");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStagesResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStages").withMarshaller((Marshaller)new ListStagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStagesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$listStages$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$listStages$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListStagesPublisher listStagesPaginator(ListStagesRequest listStagesRequest) {
        return new ListStagesPublisher(this, this.applyPaginatorUserAgent(listStagesRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$listTagsForResource$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$listTagsForResource$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$tagResource$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$tagResource$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$untagResource$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$untagResource$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStageResponse> updateStage(UpdateStageRequest updateStageRequest) {
        List<MetricPublisher> metricPublishers = DefaultIvsRealTimeAsyncClient.resolveMetricPublishers(this.clientConfiguration, updateStageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"IVS RealTime");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStageResponse::builder);
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStage").withMarshaller((Marshaller)new UpdateStageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultIvsRealTimeAsyncClient.lambda$updateStage$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultIvsRealTimeAsyncClient.lambda$updateStage$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final IvsRealTimeServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public final String serviceName() {
        return "ivs";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(IvsRealTimeException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PendingVerification").exceptionBuilderSupplier(PendingVerificationException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends IvsRealTimeRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.92").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IvsRealTimeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateStage$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStage$43(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$40(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$37(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$34(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStages$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStages$31(List metricPublishers, MetricCollector apiCallMetricCollector, ListStagesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStageSessions$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStageSessions$28(List metricPublishers, MetricCollector apiCallMetricCollector, ListStageSessionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listParticipants$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listParticipants$25(List metricPublishers, MetricCollector apiCallMetricCollector, ListParticipantsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listParticipantEvents$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listParticipantEvents$22(List metricPublishers, MetricCollector apiCallMetricCollector, ListParticipantEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStageSession$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStageSession$19(List metricPublishers, MetricCollector apiCallMetricCollector, GetStageSessionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getStage$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStage$16(List metricPublishers, MetricCollector apiCallMetricCollector, GetStageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getParticipant$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getParticipant$13(List metricPublishers, MetricCollector apiCallMetricCollector, GetParticipantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disconnectParticipant$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disconnectParticipant$10(List metricPublishers, MetricCollector apiCallMetricCollector, DisconnectParticipantResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStage$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStage$7(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStage$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStage$4(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createParticipantToken$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createParticipantToken$1(List metricPublishers, MetricCollector apiCallMetricCollector, CreateParticipantTokenResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

