/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse;

public class ListParticipantsPublisher
implements SdkPublisher<ListParticipantsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListParticipantsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListParticipantsPublisher(IvsRealTimeAsyncClient client, ListParticipantsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListParticipantsPublisher(IvsRealTimeAsyncClient client, ListParticipantsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListParticipantsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListParticipantsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListParticipantsResponseFetcher
    implements AsyncPageFetcher<ListParticipantsResponse> {
        private ListParticipantsResponseFetcher() {
        }

        public boolean hasNextPage(ListParticipantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListParticipantsResponse> nextPage(ListParticipantsResponse previousPage) {
            if (previousPage == null) {
                return ListParticipantsPublisher.this.client.listParticipants(ListParticipantsPublisher.this.firstRequest);
            }
            return ListParticipantsPublisher.this.client.listParticipants((ListParticipantsRequest)((Object)ListParticipantsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

