/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ivschat.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoomsResponse extends IvschatResponse implements
        ToCopyableBuilder<ListRoomsResponse.Builder, ListRoomsResponse> {
    private static final SdkField<List<RoomSummary>> ROOMS_FIELD = SdkField
            .<List<RoomSummary>> builder(MarshallingType.LIST)
            .memberName("rooms")
            .getter(getter(ListRoomsResponse::rooms))
            .setter(setter(Builder::rooms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rooms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoomSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoomSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRoomsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RoomSummary> rooms;

    private final String nextToken;

    private ListRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rooms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRooms() {
        return rooms != null && !(rooms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the matching rooms (summary information only).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRooms} method.
     * </p>
     * 
     * @return List of the matching rooms (summary information only).
     */
    public final List<RoomSummary> rooms() {
        return rooms;
    }

    /**
     * <p>
     * If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the next
     * set.
     * </p>
     * 
     * @return If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get
     *         the next set.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRooms() ? rooms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoomsResponse)) {
            return false;
        }
        ListRoomsResponse other = (ListRoomsResponse) obj;
        return hasRooms() == other.hasRooms() && Objects.equals(rooms(), other.rooms())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoomsResponse").add("Rooms", hasRooms() ? rooms() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rooms":
            return Optional.ofNullable(clazz.cast(rooms()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rooms", ROOMS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoomsResponse, T> g) {
        return obj -> g.apply((ListRoomsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IvschatResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoomsResponse> {
        /**
         * <p>
         * List of the matching rooms (summary information only).
         * </p>
         * 
         * @param rooms
         *        List of the matching rooms (summary information only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(Collection<RoomSummary> rooms);

        /**
         * <p>
         * List of the matching rooms (summary information only).
         * </p>
         * 
         * @param rooms
         *        List of the matching rooms (summary information only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rooms(RoomSummary... rooms);

        /**
         * <p>
         * List of the matching rooms (summary information only).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ivschat.model.RoomSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ivschat.model.RoomSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ivschat.model.RoomSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #rooms(List<RoomSummary>)}.
         * 
         * @param rooms
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ivschat.model.RoomSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rooms(java.util.Collection<RoomSummary>)
         */
        Builder rooms(Consumer<RoomSummary.Builder>... rooms);

        /**
         * <p>
         * If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get the
         * next set.
         * </p>
         * 
         * @param nextToken
         *        If there are more rooms than <code>maxResults</code>, use <code>nextToken</code> in the request to get
         *        the next set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IvschatResponse.BuilderImpl implements Builder {
        private List<RoomSummary> rooms = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoomsResponse model) {
            super(model);
            rooms(model.rooms);
            nextToken(model.nextToken);
        }

        public final List<RoomSummary.Builder> getRooms() {
            List<RoomSummary.Builder> result = RoomListCopier.copyToBuilder(this.rooms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRooms(Collection<RoomSummary.BuilderImpl> rooms) {
            this.rooms = RoomListCopier.copyFromBuilder(rooms);
        }

        @Override
        public final Builder rooms(Collection<RoomSummary> rooms) {
            this.rooms = RoomListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomSummary... rooms) {
            rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<RoomSummary.Builder>... rooms) {
            rooms(Stream.of(rooms).map(c -> RoomSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoomsResponse build() {
            return new ListRoomsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
