/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivschat.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivschat.IvschatAsyncClient;
import software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest;
import software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsResponse;

public class ListLoggingConfigurationsPublisher
implements SdkPublisher<ListLoggingConfigurationsResponse> {
    private final IvschatAsyncClient client;
    private final ListLoggingConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLoggingConfigurationsPublisher(IvschatAsyncClient client, ListLoggingConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLoggingConfigurationsPublisher(IvschatAsyncClient client, ListLoggingConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLoggingConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLoggingConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListLoggingConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListLoggingConfigurationsResponse> {
        private ListLoggingConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLoggingConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLoggingConfigurationsResponse> nextPage(ListLoggingConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListLoggingConfigurationsPublisher.this.client.listLoggingConfigurations(ListLoggingConfigurationsPublisher.this.firstRequest);
            }
            return ListLoggingConfigurationsPublisher.this.client.listLoggingConfigurations((ListLoggingConfigurationsRequest)((Object)ListLoggingConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

