/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivs.model.DestinationConfiguration;
import software.amazon.awssdk.services.ivs.model.RecordingConfigurationState;
import software.amazon.awssdk.services.ivs.model.RenditionConfiguration;
import software.amazon.awssdk.services.ivs.model.TagsCopier;
import software.amazon.awssdk.services.ivs.model.ThumbnailConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordingConfiguration> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RecordingConfiguration.getter(RecordingConfiguration::arn)).setter(RecordingConfiguration.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<DestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfiguration").getter(RecordingConfiguration.getter(RecordingConfiguration::destinationConfiguration)).setter(RecordingConfiguration.setter(Builder::destinationConfiguration)).constructor(DestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RecordingConfiguration.getter(RecordingConfiguration::name)).setter(RecordingConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> RECORDING_RECONNECT_WINDOW_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recordingReconnectWindowSeconds").getter(RecordingConfiguration.getter(RecordingConfiguration::recordingReconnectWindowSeconds)).setter(RecordingConfiguration.setter(Builder::recordingReconnectWindowSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordingReconnectWindowSeconds").build()}).build();
    private static final SdkField<RenditionConfiguration> RENDITION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("renditionConfiguration").getter(RecordingConfiguration.getter(RecordingConfiguration::renditionConfiguration)).setter(RecordingConfiguration.setter(Builder::renditionConfiguration)).constructor(RenditionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("renditionConfiguration").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(RecordingConfiguration.getter(RecordingConfiguration::stateAsString)).setter(RecordingConfiguration.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RecordingConfiguration.getter(RecordingConfiguration::tags)).setter(RecordingConfiguration.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ThumbnailConfiguration> THUMBNAIL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("thumbnailConfiguration").getter(RecordingConfiguration.getter(RecordingConfiguration::thumbnailConfiguration)).setter(RecordingConfiguration.setter(Builder::thumbnailConfiguration)).constructor(ThumbnailConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thumbnailConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESTINATION_CONFIGURATION_FIELD, NAME_FIELD, RECORDING_RECONNECT_WINDOW_SECONDS_FIELD, RENDITION_CONFIGURATION_FIELD, STATE_FIELD, TAGS_FIELD, THUMBNAIL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("destinationConfiguration", DESTINATION_CONFIGURATION_FIELD);
            this.put("name", NAME_FIELD);
            this.put("recordingReconnectWindowSeconds", RECORDING_RECONNECT_WINDOW_SECONDS_FIELD);
            this.put("renditionConfiguration", RENDITION_CONFIGURATION_FIELD);
            this.put("state", STATE_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("thumbnailConfiguration", THUMBNAIL_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final DestinationConfiguration destinationConfiguration;
    private final String name;
    private final Integer recordingReconnectWindowSeconds;
    private final RenditionConfiguration renditionConfiguration;
    private final String state;
    private final Map<String, String> tags;
    private final ThumbnailConfiguration thumbnailConfiguration;

    private RecordingConfiguration(BuilderImpl builder) {
        this.arn = builder.arn;
        this.destinationConfiguration = builder.destinationConfiguration;
        this.name = builder.name;
        this.recordingReconnectWindowSeconds = builder.recordingReconnectWindowSeconds;
        this.renditionConfiguration = builder.renditionConfiguration;
        this.state = builder.state;
        this.tags = builder.tags;
        this.thumbnailConfiguration = builder.thumbnailConfiguration;
    }

    public final String arn() {
        return this.arn;
    }

    public final DestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final Integer recordingReconnectWindowSeconds() {
        return this.recordingReconnectWindowSeconds;
    }

    public final RenditionConfiguration renditionConfiguration() {
        return this.renditionConfiguration;
    }

    public final RecordingConfigurationState state() {
        return RecordingConfigurationState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ThumbnailConfiguration thumbnailConfiguration() {
        return this.thumbnailConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordingReconnectWindowSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.renditionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbnailConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordingConfiguration)) {
            return false;
        }
        RecordingConfiguration other = (RecordingConfiguration)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.destinationConfiguration(), other.destinationConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.recordingReconnectWindowSeconds(), other.recordingReconnectWindowSeconds()) && Objects.equals(this.renditionConfiguration(), other.renditionConfiguration()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.thumbnailConfiguration(), other.thumbnailConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RecordingConfiguration").add("Arn", (Object)this.arn()).add("DestinationConfiguration", (Object)this.destinationConfiguration()).add("Name", (Object)this.name()).add("RecordingReconnectWindowSeconds", (Object)this.recordingReconnectWindowSeconds()).add("RenditionConfiguration", (Object)this.renditionConfiguration()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ThumbnailConfiguration", (Object)this.thumbnailConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "recordingReconnectWindowSeconds": {
                return Optional.ofNullable(clazz.cast(this.recordingReconnectWindowSeconds()));
            }
            case "renditionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.renditionConfiguration()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "thumbnailConfiguration": {
                return Optional.ofNullable(clazz.cast(this.thumbnailConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RecordingConfiguration, T> g) {
        return obj -> g.apply((RecordingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private DestinationConfiguration destinationConfiguration;
        private String name;
        private Integer recordingReconnectWindowSeconds;
        private RenditionConfiguration renditionConfiguration;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ThumbnailConfiguration thumbnailConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordingConfiguration model) {
            this.arn(model.arn);
            this.destinationConfiguration(model.destinationConfiguration);
            this.name(model.name);
            this.recordingReconnectWindowSeconds(model.recordingReconnectWindowSeconds);
            this.renditionConfiguration(model.renditionConfiguration);
            this.state(model.state);
            this.tags(model.tags);
            this.thumbnailConfiguration(model.thumbnailConfiguration);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        public final void setDestinationConfiguration(DestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public final Builder destinationConfiguration(DestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getRecordingReconnectWindowSeconds() {
            return this.recordingReconnectWindowSeconds;
        }

        public final void setRecordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
        }

        @Override
        public final Builder recordingReconnectWindowSeconds(Integer recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
            return this;
        }

        public final RenditionConfiguration.Builder getRenditionConfiguration() {
            return this.renditionConfiguration != null ? this.renditionConfiguration.toBuilder() : null;
        }

        public final void setRenditionConfiguration(RenditionConfiguration.BuilderImpl renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration != null ? renditionConfiguration.build() : null;
        }

        @Override
        public final Builder renditionConfiguration(RenditionConfiguration renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RecordingConfigurationState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final ThumbnailConfiguration.Builder getThumbnailConfiguration() {
            return this.thumbnailConfiguration != null ? this.thumbnailConfiguration.toBuilder() : null;
        }

        public final void setThumbnailConfiguration(ThumbnailConfiguration.BuilderImpl thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration != null ? thumbnailConfiguration.build() : null;
        }

        @Override
        public final Builder thumbnailConfiguration(ThumbnailConfiguration thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        public RecordingConfiguration build() {
            return new RecordingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordingConfiguration> {
        public Builder arn(String var1);

        public Builder destinationConfiguration(DestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<DestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((DestinationConfiguration)((DestinationConfiguration.Builder)DestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder recordingReconnectWindowSeconds(Integer var1);

        public Builder renditionConfiguration(RenditionConfiguration var1);

        default public Builder renditionConfiguration(Consumer<RenditionConfiguration.Builder> renditionConfiguration) {
            return this.renditionConfiguration((RenditionConfiguration)((RenditionConfiguration.Builder)RenditionConfiguration.builder().applyMutation(renditionConfiguration)).build());
        }

        public Builder state(String var1);

        public Builder state(RecordingConfigurationState var1);

        public Builder tags(Map<String, String> var1);

        public Builder thumbnailConfiguration(ThumbnailConfiguration var1);

        default public Builder thumbnailConfiguration(Consumer<ThumbnailConfiguration.Builder> thumbnailConfiguration) {
            return this.thumbnailConfiguration((ThumbnailConfiguration)((ThumbnailConfiguration.Builder)ThumbnailConfiguration.builder().applyMutation(thumbnailConfiguration)).build());
        }
    }
}

