/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicyAllowedCountryListCopier;
import software.amazon.awssdk.services.ivs.model.PlaybackRestrictionPolicyAllowedOriginListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePlaybackRestrictionPolicyRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, UpdatePlaybackRestrictionPolicyRequest> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdatePlaybackRestrictionPolicyRequest.getter(UpdatePlaybackRestrictionPolicyRequest::arn)).setter(UpdatePlaybackRestrictionPolicyRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<List<String>> ALLOWED_COUNTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedCountries").getter(UpdatePlaybackRestrictionPolicyRequest.getter(UpdatePlaybackRestrictionPolicyRequest::allowedCountries)).setter(UpdatePlaybackRestrictionPolicyRequest.setter(Builder::allowedCountries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedCountries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_ORIGINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedOrigins").getter(UpdatePlaybackRestrictionPolicyRequest.getter(UpdatePlaybackRestrictionPolicyRequest::allowedOrigins)).setter(UpdatePlaybackRestrictionPolicyRequest.setter(Builder::allowedOrigins)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOrigins").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_STRICT_ORIGIN_ENFORCEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enableStrictOriginEnforcement").getter(UpdatePlaybackRestrictionPolicyRequest.getter(UpdatePlaybackRestrictionPolicyRequest::enableStrictOriginEnforcement)).setter(UpdatePlaybackRestrictionPolicyRequest.setter(Builder::enableStrictOriginEnforcement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableStrictOriginEnforcement").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdatePlaybackRestrictionPolicyRequest.getter(UpdatePlaybackRestrictionPolicyRequest::name)).setter(UpdatePlaybackRestrictionPolicyRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALLOWED_COUNTRIES_FIELD, ALLOWED_ORIGINS_FIELD, ENABLE_STRICT_ORIGIN_ENFORCEMENT_FIELD, NAME_FIELD));
    private final String arn;
    private final List<String> allowedCountries;
    private final List<String> allowedOrigins;
    private final Boolean enableStrictOriginEnforcement;
    private final String name;

    private UpdatePlaybackRestrictionPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.allowedCountries = builder.allowedCountries;
        this.allowedOrigins = builder.allowedOrigins;
        this.enableStrictOriginEnforcement = builder.enableStrictOriginEnforcement;
        this.name = builder.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasAllowedCountries() {
        return this.allowedCountries != null && !(this.allowedCountries instanceof SdkAutoConstructList);
    }

    public final List<String> allowedCountries() {
        return this.allowedCountries;
    }

    public final boolean hasAllowedOrigins() {
        return this.allowedOrigins != null && !(this.allowedOrigins instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOrigins() {
        return this.allowedOrigins;
    }

    public final Boolean enableStrictOriginEnforcement() {
        return this.enableStrictOriginEnforcement;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedCountries() ? this.allowedCountries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOrigins() ? this.allowedOrigins() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.enableStrictOriginEnforcement());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePlaybackRestrictionPolicyRequest)) {
            return false;
        }
        UpdatePlaybackRestrictionPolicyRequest other = (UpdatePlaybackRestrictionPolicyRequest)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && this.hasAllowedCountries() == other.hasAllowedCountries() && Objects.equals(this.allowedCountries(), other.allowedCountries()) && this.hasAllowedOrigins() == other.hasAllowedOrigins() && Objects.equals(this.allowedOrigins(), other.allowedOrigins()) && Objects.equals(this.enableStrictOriginEnforcement(), other.enableStrictOriginEnforcement()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePlaybackRestrictionPolicyRequest").add("Arn", (Object)this.arn()).add("AllowedCountries", this.hasAllowedCountries() ? this.allowedCountries() : null).add("AllowedOrigins", this.hasAllowedOrigins() ? this.allowedOrigins() : null).add("EnableStrictOriginEnforcement", (Object)this.enableStrictOriginEnforcement()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "allowedCountries": {
                return Optional.ofNullable(clazz.cast(this.allowedCountries()));
            }
            case "allowedOrigins": {
                return Optional.ofNullable(clazz.cast(this.allowedOrigins()));
            }
            case "enableStrictOriginEnforcement": {
                return Optional.ofNullable(clazz.cast(this.enableStrictOriginEnforcement()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePlaybackRestrictionPolicyRequest, T> g) {
        return obj -> g.apply((UpdatePlaybackRestrictionPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String arn;
        private List<String> allowedCountries = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedOrigins = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableStrictOriginEnforcement;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePlaybackRestrictionPolicyRequest model) {
            super(model);
            this.arn(model.arn);
            this.allowedCountries(model.allowedCountries);
            this.allowedOrigins(model.allowedOrigins);
            this.enableStrictOriginEnforcement(model.enableStrictOriginEnforcement);
            this.name(model.name);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAllowedCountries() {
            if (this.allowedCountries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedCountries;
        }

        public final void setAllowedCountries(Collection<String> allowedCountries) {
            this.allowedCountries = PlaybackRestrictionPolicyAllowedCountryListCopier.copy(allowedCountries);
        }

        @Override
        public final Builder allowedCountries(Collection<String> allowedCountries) {
            this.allowedCountries = PlaybackRestrictionPolicyAllowedCountryListCopier.copy(allowedCountries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedCountries(String ... allowedCountries) {
            this.allowedCountries(Arrays.asList(allowedCountries));
            return this;
        }

        public final Collection<String> getAllowedOrigins() {
            if (this.allowedOrigins instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOrigins;
        }

        public final void setAllowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = PlaybackRestrictionPolicyAllowedOriginListCopier.copy(allowedOrigins);
        }

        @Override
        public final Builder allowedOrigins(Collection<String> allowedOrigins) {
            this.allowedOrigins = PlaybackRestrictionPolicyAllowedOriginListCopier.copy(allowedOrigins);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrigins(String ... allowedOrigins) {
            this.allowedOrigins(Arrays.asList(allowedOrigins));
            return this;
        }

        public final Boolean getEnableStrictOriginEnforcement() {
            return this.enableStrictOriginEnforcement;
        }

        public final void setEnableStrictOriginEnforcement(Boolean enableStrictOriginEnforcement) {
            this.enableStrictOriginEnforcement = enableStrictOriginEnforcement;
        }

        @Override
        public final Builder enableStrictOriginEnforcement(Boolean enableStrictOriginEnforcement) {
            this.enableStrictOriginEnforcement = enableStrictOriginEnforcement;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePlaybackRestrictionPolicyRequest build() {
            return new UpdatePlaybackRestrictionPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePlaybackRestrictionPolicyRequest> {
        public Builder arn(String var1);

        public Builder allowedCountries(Collection<String> var1);

        public Builder allowedCountries(String ... var1);

        public Builder allowedOrigins(Collection<String> var1);

        public Builder allowedOrigins(String ... var1);

        public Builder enableStrictOriginEnforcement(Boolean var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

