/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.IvsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetStreamSessionRequest
extends IvsRequest
implements ToCopyableBuilder<Builder, GetStreamSessionRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(GetStreamSessionRequest.getter(GetStreamSessionRequest::channelArn)).setter(GetStreamSessionRequest.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("streamId").getter(GetStreamSessionRequest.getter(GetStreamSessionRequest::streamId)).setter(GetStreamSessionRequest.setter(Builder::streamId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, STREAM_ID_FIELD));
    private final String channelArn;
    private final String streamId;

    private GetStreamSessionRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.streamId = builder.streamId;
    }

    public final String channelArn() {
        return this.channelArn;
    }

    public final String streamId() {
        return this.streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStreamSessionRequest)) {
            return false;
        }
        GetStreamSessionRequest other = (GetStreamSessionRequest)((Object)obj);
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.streamId(), other.streamId());
    }

    public final String toString() {
        return ToString.builder((String)"GetStreamSessionRequest").add("ChannelArn", (Object)this.channelArn()).add("StreamId", (Object)this.streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "streamId": {
                return Optional.ofNullable(clazz.cast(this.streamId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStreamSessionRequest, T> g) {
        return obj -> g.apply((GetStreamSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsRequest.BuilderImpl
    implements Builder {
        private String channelArn;
        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStreamSessionRequest model) {
            super(model);
            this.channelArn(model.channelArn);
            this.streamId(model.streamId);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getStreamId() {
            return this.streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetStreamSessionRequest build() {
            return new GetStreamSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetStreamSessionRequest> {
        public Builder channelArn(String var1);

        public Builder streamId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

