/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ivs.model.IvsResponse;
import software.amazon.awssdk.services.ivs.model.StreamKeyListCopier;
import software.amazon.awssdk.services.ivs.model.StreamKeySummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListStreamKeysResponse
extends IvsResponse
implements ToCopyableBuilder<Builder, ListStreamKeysResponse> {
    private static final SdkField<List<StreamKeySummary>> STREAM_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("streamKeys").getter(ListStreamKeysResponse.getter(ListStreamKeysResponse::streamKeys)).setter(ListStreamKeysResponse.setter(Builder::streamKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreamKeySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListStreamKeysResponse.getter(ListStreamKeysResponse::nextToken)).setter(ListStreamKeysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_KEYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<StreamKeySummary> streamKeys;
    private final String nextToken;

    private ListStreamKeysResponse(BuilderImpl builder) {
        super(builder);
        this.streamKeys = builder.streamKeys;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStreamKeys() {
        return this.streamKeys != null && !(this.streamKeys instanceof SdkAutoConstructList);
    }

    public final List<StreamKeySummary> streamKeys() {
        return this.streamKeys;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreamKeys() ? this.streamKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStreamKeysResponse)) {
            return false;
        }
        ListStreamKeysResponse other = (ListStreamKeysResponse)((Object)obj);
        return this.hasStreamKeys() == other.hasStreamKeys() && Objects.equals(this.streamKeys(), other.streamKeys()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListStreamKeysResponse").add("StreamKeys", this.hasStreamKeys() ? this.streamKeys() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "streamKeys": {
                return Optional.ofNullable(clazz.cast(this.streamKeys()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStreamKeysResponse, T> g) {
        return obj -> g.apply((ListStreamKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IvsResponse.BuilderImpl
    implements Builder {
        private List<StreamKeySummary> streamKeys = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStreamKeysResponse model) {
            super(model);
            this.streamKeys(model.streamKeys);
            this.nextToken(model.nextToken);
        }

        public final List<StreamKeySummary.Builder> getStreamKeys() {
            List<StreamKeySummary.Builder> result = StreamKeyListCopier.copyToBuilder(this.streamKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreamKeys(Collection<StreamKeySummary.BuilderImpl> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copyFromBuilder(streamKeys);
        }

        @Override
        @Transient
        public final Builder streamKeys(Collection<StreamKeySummary> streamKeys) {
            this.streamKeys = StreamKeyListCopier.copy(streamKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamKeys(StreamKeySummary ... streamKeys) {
            this.streamKeys(Arrays.asList(streamKeys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder streamKeys(Consumer<StreamKeySummary.Builder> ... streamKeys) {
            this.streamKeys(Stream.of(streamKeys).map(c -> (StreamKeySummary)((StreamKeySummary.Builder)StreamKeySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListStreamKeysResponse build() {
            return new ListStreamKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IvsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListStreamKeysResponse> {
        public Builder streamKeys(Collection<StreamKeySummary> var1);

        public Builder streamKeys(StreamKeySummary ... var1);

        public Builder streamKeys(Consumer<StreamKeySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

