/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.model.ListStreamsRequest;
import software.amazon.awssdk.services.ivs.model.ListStreamsResponse;

public class ListStreamsIterable
implements SdkIterable<ListStreamsResponse> {
    private final IvsClient client;
    private final ListStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamsIterable(IvsClient client, ListStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamsResponseFetcher();
    }

    public Iterator<ListStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStreamsResponseFetcher
    implements SyncPageFetcher<ListStreamsResponse> {
        private ListStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamsResponse nextPage(ListStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListStreamsIterable.this.client.listStreams(ListStreamsIterable.this.firstRequest);
            }
            return ListStreamsIterable.this.client.listStreams((ListStreamsRequest)((Object)ListStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

