/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivs.model.StreamHealth;
import software.amazon.awssdk.services.ivs.model.StreamState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stream> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("channelArn").getter(Stream.getter(Stream::channelArn)).setter(Stream.setter(Builder::channelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelArn").build()}).build();
    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("playbackUrl").getter(Stream.getter(Stream::playbackUrl)).setter(Stream.setter(Builder::playbackUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("playbackUrl").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(Stream.getter(Stream::startTime)).setter(Stream.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(Stream.getter(Stream::stateAsString)).setter(Stream.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> HEALTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("health").getter(Stream.getter(Stream::healthAsString)).setter(Stream.setter(Builder::health)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("health").build()}).build();
    private static final SdkField<Long> VIEWER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("viewerCount").getter(Stream.getter(Stream::viewerCount)).setter(Stream.setter(Builder::viewerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("viewerCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, PLAYBACK_URL_FIELD, START_TIME_FIELD, STATE_FIELD, HEALTH_FIELD, VIEWER_COUNT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String channelArn;
    private final String playbackUrl;
    private final Instant startTime;
    private final String state;
    private final String health;
    private final Long viewerCount;

    private Stream(BuilderImpl builder) {
        this.channelArn = builder.channelArn;
        this.playbackUrl = builder.playbackUrl;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.health = builder.health;
        this.viewerCount = builder.viewerCount;
    }

    public String channelArn() {
        return this.channelArn;
    }

    public String playbackUrl() {
        return this.playbackUrl;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public StreamState state() {
        return StreamState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public StreamHealth health() {
        return StreamHealth.fromValue(this.health);
    }

    public String healthAsString() {
        return this.health;
    }

    public Long viewerCount() {
        return this.viewerCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewerCount());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)obj;
        return Objects.equals(this.channelArn(), other.channelArn()) && Objects.equals(this.playbackUrl(), other.playbackUrl()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.healthAsString(), other.healthAsString()) && Objects.equals(this.viewerCount(), other.viewerCount());
    }

    public String toString() {
        return ToString.builder((String)"Stream").add("ChannelArn", (Object)this.channelArn()).add("PlaybackUrl", (Object)this.playbackUrl()).add("StartTime", (Object)this.startTime()).add("State", (Object)this.stateAsString()).add("Health", (Object)this.healthAsString()).add("ViewerCount", (Object)this.viewerCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "channelArn": {
                return Optional.ofNullable(clazz.cast(this.channelArn()));
            }
            case "playbackUrl": {
                return Optional.ofNullable(clazz.cast(this.playbackUrl()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "health": {
                return Optional.ofNullable(clazz.cast(this.healthAsString()));
            }
            case "viewerCount": {
                return Optional.ofNullable(clazz.cast(this.viewerCount()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stream, T> g) {
        return obj -> g.apply((Stream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String channelArn;
        private String playbackUrl;
        private Instant startTime;
        private String state;
        private String health;
        private Long viewerCount;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            this.channelArn(model.channelArn);
            this.playbackUrl(model.playbackUrl);
            this.startTime(model.startTime);
            this.state(model.state);
            this.health(model.health);
            this.viewerCount(model.viewerCount);
        }

        public final String getChannelArn() {
            return this.channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        public final String getPlaybackUrl() {
            return this.playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(StreamState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getHealth() {
            return this.health;
        }

        @Override
        public final Builder health(String health) {
            this.health = health;
            return this;
        }

        @Override
        public final Builder health(StreamHealth health) {
            this.health(health == null ? null : health.toString());
            return this;
        }

        public final void setHealth(String health) {
            this.health = health;
        }

        public final Long getViewerCount() {
            return this.viewerCount;
        }

        @Override
        public final Builder viewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
            return this;
        }

        public final void setViewerCount(Long viewerCount) {
            this.viewerCount = viewerCount;
        }

        public Stream build() {
            return new Stream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stream> {
        public Builder channelArn(String var1);

        public Builder playbackUrl(String var1);

        public Builder startTime(Instant var1);

        public Builder state(String var1);

        public Builder state(StreamState var1);

        public Builder health(String var1);

        public Builder health(StreamHealth var1);

        public Builder viewerCount(Long var1);
    }
}

