/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.SummaryMetricQueriesCopier;
import software.amazon.awssdk.services.iotwireless.model.SummaryMetricQuery;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricsRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, GetMetricsRequest> {
    private static final SdkField<List<SummaryMetricQuery>> SUMMARY_METRIC_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SummaryMetricQueries").getter(GetMetricsRequest.getter(GetMetricsRequest::summaryMetricQueries)).setter(GetMetricsRequest.setter(Builder::summaryMetricQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryMetricQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SummaryMetricQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_METRIC_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMetricsRequest.memberNameToFieldInitializer();
    private final List<SummaryMetricQuery> summaryMetricQueries;

    private GetMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.summaryMetricQueries = builder.summaryMetricQueries;
    }

    public final boolean hasSummaryMetricQueries() {
        return this.summaryMetricQueries != null && !(this.summaryMetricQueries instanceof SdkAutoConstructList);
    }

    public final List<SummaryMetricQuery> summaryMetricQueries() {
        return this.summaryMetricQueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaryMetricQueries() ? this.summaryMetricQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricsRequest)) {
            return false;
        }
        GetMetricsRequest other = (GetMetricsRequest)((Object)obj);
        return this.hasSummaryMetricQueries() == other.hasSummaryMetricQueries() && Objects.equals(this.summaryMetricQueries(), other.summaryMetricQueries());
    }

    public final String toString() {
        return ToString.builder((String)"GetMetricsRequest").add("SummaryMetricQueries", this.hasSummaryMetricQueries() ? this.summaryMetricQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryMetricQueries": {
                return Optional.ofNullable(clazz.cast(this.summaryMetricQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SummaryMetricQuery>>> map = new HashMap<String, SdkField<List<SummaryMetricQuery>>>();
        map.put("SummaryMetricQueries", SUMMARY_METRIC_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMetricsRequest, T> g) {
        return obj -> g.apply((GetMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private List<SummaryMetricQuery> summaryMetricQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricsRequest model) {
            super(model);
            this.summaryMetricQueries(model.summaryMetricQueries);
        }

        public final List<SummaryMetricQuery.Builder> getSummaryMetricQueries() {
            List<SummaryMetricQuery.Builder> result = SummaryMetricQueriesCopier.copyToBuilder(this.summaryMetricQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaryMetricQueries(Collection<SummaryMetricQuery.BuilderImpl> summaryMetricQueries) {
            this.summaryMetricQueries = SummaryMetricQueriesCopier.copyFromBuilder(summaryMetricQueries);
        }

        @Override
        public final Builder summaryMetricQueries(Collection<SummaryMetricQuery> summaryMetricQueries) {
            this.summaryMetricQueries = SummaryMetricQueriesCopier.copy(summaryMetricQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryMetricQueries(SummaryMetricQuery ... summaryMetricQueries) {
            this.summaryMetricQueries(Arrays.asList(summaryMetricQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaryMetricQueries(Consumer<SummaryMetricQuery.Builder> ... summaryMetricQueries) {
            this.summaryMetricQueries(Stream.of(summaryMetricQueries).map(c -> (SummaryMetricQuery)((SummaryMetricQuery.Builder)SummaryMetricQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMetricsRequest build() {
            return new GetMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricsRequest> {
        public Builder summaryMetricQueries(Collection<SummaryMetricQuery> var1);

        public Builder summaryMetricQueries(SummaryMetricQuery ... var1);

        public Builder summaryMetricQueries(Consumer<SummaryMetricQuery.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

