/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.PositionResourceType;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPositionConfigurationRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, PutPositionConfigurationRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceIdentifier").getter(PutPositionConfigurationRequest.getter(PutPositionConfigurationRequest::resourceIdentifier)).setter(PutPositionConfigurationRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ResourceIdentifier").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(PutPositionConfigurationRequest.getter(PutPositionConfigurationRequest::resourceTypeAsString)).setter(PutPositionConfigurationRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceType").build()}).build();
    private static final SdkField<PositionSolverConfigurations> SOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Solvers").getter(PutPositionConfigurationRequest.getter(PutPositionConfigurationRequest::solvers)).setter(PutPositionConfigurationRequest.setter(Builder::solvers)).constructor(PositionSolverConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solvers").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(PutPositionConfigurationRequest.getter(PutPositionConfigurationRequest::destination)).setter(PutPositionConfigurationRequest.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, SOLVERS_FIELD, DESTINATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutPositionConfigurationRequest.memberNameToFieldInitializer();
    private final String resourceIdentifier;
    private final String resourceType;
    private final PositionSolverConfigurations solvers;
    private final String destination;

    private PutPositionConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceType = builder.resourceType;
        this.solvers = builder.solvers;
        this.destination = builder.destination;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final PositionResourceType resourceType() {
        return PositionResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final PositionSolverConfigurations solvers() {
        return this.solvers;
    }

    public final String destination() {
        return this.destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.solvers());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPositionConfigurationRequest)) {
            return false;
        }
        PutPositionConfigurationRequest other = (PutPositionConfigurationRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.solvers(), other.solvers()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"PutPositionConfigurationRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Solvers", (Object)this.solvers()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Solvers": {
                return Optional.ofNullable(clazz.cast(this.solvers()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("Solvers", SOLVERS_FIELD);
        map.put("Destination", DESTINATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutPositionConfigurationRequest, T> g) {
        return obj -> g.apply((PutPositionConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private String resourceType;
        private PositionSolverConfigurations solvers;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPositionConfigurationRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.resourceType(model.resourceType);
            this.solvers(model.solvers);
            this.destination(model.destination);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(PositionResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final PositionSolverConfigurations.Builder getSolvers() {
            return this.solvers != null ? this.solvers.toBuilder() : null;
        }

        public final void setSolvers(PositionSolverConfigurations.BuilderImpl solvers) {
            this.solvers = solvers != null ? solvers.build() : null;
        }

        @Override
        public final Builder solvers(PositionSolverConfigurations solvers) {
            this.solvers = solvers;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPositionConfigurationRequest build() {
            return new PutPositionConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPositionConfigurationRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(PositionResourceType var1);

        public Builder solvers(PositionSolverConfigurations var1);

        default public Builder solvers(Consumer<PositionSolverConfigurations.Builder> solvers) {
            return this.solvers((PositionSolverConfigurations)((PositionSolverConfigurations.Builder)PositionSolverConfigurations.builder().applyMutation(solvers)).build());
        }

        public Builder destination(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

