/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.LogLevel;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOption;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayEventLogOptionListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WirelessGatewayLogOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WirelessGatewayLogOption> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(WirelessGatewayLogOption.getter(WirelessGatewayLogOption::typeAsString)).setter(WirelessGatewayLogOption.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(WirelessGatewayLogOption.getter(WirelessGatewayLogOption::logLevelAsString)).setter(WirelessGatewayLogOption.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<List<WirelessGatewayEventLogOption>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(WirelessGatewayLogOption.getter(WirelessGatewayLogOption::events)).setter(WirelessGatewayLogOption.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WirelessGatewayEventLogOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, LOG_LEVEL_FIELD, EVENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WirelessGatewayLogOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String logLevel;
    private final List<WirelessGatewayEventLogOption> events;

    private WirelessGatewayLogOption(BuilderImpl builder) {
        this.type = builder.type;
        this.logLevel = builder.logLevel;
        this.events = builder.events;
    }

    public final WirelessGatewayType type() {
        return WirelessGatewayType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<WirelessGatewayEventLogOption> events() {
        return this.events;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessGatewayLogOption)) {
            return false;
        }
        WirelessGatewayLogOption other = (WirelessGatewayLogOption)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events());
    }

    public final String toString() {
        return ToString.builder((String)"WirelessGatewayLogOption").add("Type", (Object)this.typeAsString()).add("LogLevel", (Object)this.logLevelAsString()).add("Events", this.hasEvents() ? this.events() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("LogLevel", LOG_LEVEL_FIELD);
        map.put("Events", EVENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WirelessGatewayLogOption, T> g) {
        return obj -> g.apply((WirelessGatewayLogOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String logLevel;
        private List<WirelessGatewayEventLogOption> events = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessGatewayLogOption model) {
            this.type(model.type);
            this.logLevel(model.logLevel);
            this.events(model.events);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessGatewayType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final List<WirelessGatewayEventLogOption.Builder> getEvents() {
            List<WirelessGatewayEventLogOption.Builder> result = WirelessGatewayEventLogOptionListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<WirelessGatewayEventLogOption.BuilderImpl> events) {
            this.events = WirelessGatewayEventLogOptionListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<WirelessGatewayEventLogOption> events) {
            this.events = WirelessGatewayEventLogOptionListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(WirelessGatewayEventLogOption ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<WirelessGatewayEventLogOption.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (WirelessGatewayEventLogOption)((WirelessGatewayEventLogOption.Builder)WirelessGatewayEventLogOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public WirelessGatewayLogOption build() {
            return new WirelessGatewayLogOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WirelessGatewayLogOption> {
        public Builder type(String var1);

        public Builder type(WirelessGatewayType var1);

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder events(Collection<WirelessGatewayEventLogOption> var1);

        public Builder events(WirelessGatewayEventLogOption ... var1);

        public Builder events(Consumer<WirelessGatewayEventLogOption.Builder> ... var1);
    }
}

