/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.NetworkAnalyzerMulticastGroupListCopier;
import software.amazon.awssdk.services.iotwireless.model.TraceContent;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceListCopier;
import software.amazon.awssdk.services.iotwireless.model.WirelessGatewayListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateNetworkAnalyzerConfigurationRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, UpdateNetworkAnalyzerConfigurationRequest> {
    private static final SdkField<String> CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConfigurationName").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::configurationName)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::configurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ConfigurationName").build()}).build();
    private static final SdkField<TraceContent> TRACE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TraceContent").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::traceContent)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::traceContent)).constructor(TraceContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TraceContent").build()}).build();
    private static final SdkField<List<String>> WIRELESS_DEVICES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDevicesToAdd").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessDevicesToAdd)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessDevicesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevicesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WIRELESS_DEVICES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessDevicesToRemove").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessDevicesToRemove)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessDevicesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessDevicesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WIRELESS_GATEWAYS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGatewaysToAdd").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessGatewaysToAdd)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessGatewaysToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewaysToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> WIRELESS_GATEWAYS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WirelessGatewaysToRemove").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::wirelessGatewaysToRemove)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::wirelessGatewaysToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewaysToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::description)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> MULTICAST_GROUPS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MulticastGroupsToAdd").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::multicastGroupsToAdd)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::multicastGroupsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroupsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MULTICAST_GROUPS_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MulticastGroupsToRemove").getter(UpdateNetworkAnalyzerConfigurationRequest.getter(UpdateNetworkAnalyzerConfigurationRequest::multicastGroupsToRemove)).setter(UpdateNetworkAnalyzerConfigurationRequest.setter(Builder::multicastGroupsToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroupsToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_NAME_FIELD, TRACE_CONTENT_FIELD, WIRELESS_DEVICES_TO_ADD_FIELD, WIRELESS_DEVICES_TO_REMOVE_FIELD, WIRELESS_GATEWAYS_TO_ADD_FIELD, WIRELESS_GATEWAYS_TO_REMOVE_FIELD, DESCRIPTION_FIELD, MULTICAST_GROUPS_TO_ADD_FIELD, MULTICAST_GROUPS_TO_REMOVE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateNetworkAnalyzerConfigurationRequest.memberNameToFieldInitializer();
    private final String configurationName;
    private final TraceContent traceContent;
    private final List<String> wirelessDevicesToAdd;
    private final List<String> wirelessDevicesToRemove;
    private final List<String> wirelessGatewaysToAdd;
    private final List<String> wirelessGatewaysToRemove;
    private final String description;
    private final List<String> multicastGroupsToAdd;
    private final List<String> multicastGroupsToRemove;

    private UpdateNetworkAnalyzerConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configurationName = builder.configurationName;
        this.traceContent = builder.traceContent;
        this.wirelessDevicesToAdd = builder.wirelessDevicesToAdd;
        this.wirelessDevicesToRemove = builder.wirelessDevicesToRemove;
        this.wirelessGatewaysToAdd = builder.wirelessGatewaysToAdd;
        this.wirelessGatewaysToRemove = builder.wirelessGatewaysToRemove;
        this.description = builder.description;
        this.multicastGroupsToAdd = builder.multicastGroupsToAdd;
        this.multicastGroupsToRemove = builder.multicastGroupsToRemove;
    }

    public final String configurationName() {
        return this.configurationName;
    }

    public final TraceContent traceContent() {
        return this.traceContent;
    }

    public final boolean hasWirelessDevicesToAdd() {
        return this.wirelessDevicesToAdd != null && !(this.wirelessDevicesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessDevicesToAdd() {
        return this.wirelessDevicesToAdd;
    }

    public final boolean hasWirelessDevicesToRemove() {
        return this.wirelessDevicesToRemove != null && !(this.wirelessDevicesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessDevicesToRemove() {
        return this.wirelessDevicesToRemove;
    }

    public final boolean hasWirelessGatewaysToAdd() {
        return this.wirelessGatewaysToAdd != null && !(this.wirelessGatewaysToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessGatewaysToAdd() {
        return this.wirelessGatewaysToAdd;
    }

    public final boolean hasWirelessGatewaysToRemove() {
        return this.wirelessGatewaysToRemove != null && !(this.wirelessGatewaysToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> wirelessGatewaysToRemove() {
        return this.wirelessGatewaysToRemove;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasMulticastGroupsToAdd() {
        return this.multicastGroupsToAdd != null && !(this.multicastGroupsToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> multicastGroupsToAdd() {
        return this.multicastGroupsToAdd;
    }

    public final boolean hasMulticastGroupsToRemove() {
        return this.multicastGroupsToRemove != null && !(this.multicastGroupsToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> multicastGroupsToRemove() {
        return this.multicastGroupsToRemove;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDevicesToAdd() ? this.wirelessDevicesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessDevicesToRemove() ? this.wirelessDevicesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGatewaysToAdd() ? this.wirelessGatewaysToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWirelessGatewaysToRemove() ? this.wirelessGatewaysToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMulticastGroupsToAdd() ? this.multicastGroupsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMulticastGroupsToRemove() ? this.multicastGroupsToRemove() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNetworkAnalyzerConfigurationRequest)) {
            return false;
        }
        UpdateNetworkAnalyzerConfigurationRequest other = (UpdateNetworkAnalyzerConfigurationRequest)((Object)obj);
        return Objects.equals(this.configurationName(), other.configurationName()) && Objects.equals(this.traceContent(), other.traceContent()) && this.hasWirelessDevicesToAdd() == other.hasWirelessDevicesToAdd() && Objects.equals(this.wirelessDevicesToAdd(), other.wirelessDevicesToAdd()) && this.hasWirelessDevicesToRemove() == other.hasWirelessDevicesToRemove() && Objects.equals(this.wirelessDevicesToRemove(), other.wirelessDevicesToRemove()) && this.hasWirelessGatewaysToAdd() == other.hasWirelessGatewaysToAdd() && Objects.equals(this.wirelessGatewaysToAdd(), other.wirelessGatewaysToAdd()) && this.hasWirelessGatewaysToRemove() == other.hasWirelessGatewaysToRemove() && Objects.equals(this.wirelessGatewaysToRemove(), other.wirelessGatewaysToRemove()) && Objects.equals(this.description(), other.description()) && this.hasMulticastGroupsToAdd() == other.hasMulticastGroupsToAdd() && Objects.equals(this.multicastGroupsToAdd(), other.multicastGroupsToAdd()) && this.hasMulticastGroupsToRemove() == other.hasMulticastGroupsToRemove() && Objects.equals(this.multicastGroupsToRemove(), other.multicastGroupsToRemove());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateNetworkAnalyzerConfigurationRequest").add("ConfigurationName", (Object)this.configurationName()).add("TraceContent", (Object)this.traceContent()).add("WirelessDevicesToAdd", this.hasWirelessDevicesToAdd() ? this.wirelessDevicesToAdd() : null).add("WirelessDevicesToRemove", this.hasWirelessDevicesToRemove() ? this.wirelessDevicesToRemove() : null).add("WirelessGatewaysToAdd", this.hasWirelessGatewaysToAdd() ? this.wirelessGatewaysToAdd() : null).add("WirelessGatewaysToRemove", this.hasWirelessGatewaysToRemove() ? this.wirelessGatewaysToRemove() : null).add("Description", (Object)this.description()).add("MulticastGroupsToAdd", this.hasMulticastGroupsToAdd() ? this.multicastGroupsToAdd() : null).add("MulticastGroupsToRemove", this.hasMulticastGroupsToRemove() ? this.multicastGroupsToRemove() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.configurationName()));
            }
            case "TraceContent": {
                return Optional.ofNullable(clazz.cast(this.traceContent()));
            }
            case "WirelessDevicesToAdd": {
                return Optional.ofNullable(clazz.cast(this.wirelessDevicesToAdd()));
            }
            case "WirelessDevicesToRemove": {
                return Optional.ofNullable(clazz.cast(this.wirelessDevicesToRemove()));
            }
            case "WirelessGatewaysToAdd": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewaysToAdd()));
            }
            case "WirelessGatewaysToRemove": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewaysToRemove()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "MulticastGroupsToAdd": {
                return Optional.ofNullable(clazz.cast(this.multicastGroupsToAdd()));
            }
            case "MulticastGroupsToRemove": {
                return Optional.ofNullable(clazz.cast(this.multicastGroupsToRemove()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ConfigurationName", CONFIGURATION_NAME_FIELD);
        map.put("TraceContent", TRACE_CONTENT_FIELD);
        map.put("WirelessDevicesToAdd", WIRELESS_DEVICES_TO_ADD_FIELD);
        map.put("WirelessDevicesToRemove", WIRELESS_DEVICES_TO_REMOVE_FIELD);
        map.put("WirelessGatewaysToAdd", WIRELESS_GATEWAYS_TO_ADD_FIELD);
        map.put("WirelessGatewaysToRemove", WIRELESS_GATEWAYS_TO_REMOVE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("MulticastGroupsToAdd", MULTICAST_GROUPS_TO_ADD_FIELD);
        map.put("MulticastGroupsToRemove", MULTICAST_GROUPS_TO_REMOVE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateNetworkAnalyzerConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateNetworkAnalyzerConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private String configurationName;
        private TraceContent traceContent;
        private List<String> wirelessDevicesToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> wirelessDevicesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> wirelessGatewaysToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> wirelessGatewaysToRemove = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private List<String> multicastGroupsToAdd = DefaultSdkAutoConstructList.getInstance();
        private List<String> multicastGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNetworkAnalyzerConfigurationRequest model) {
            super(model);
            this.configurationName(model.configurationName);
            this.traceContent(model.traceContent);
            this.wirelessDevicesToAdd(model.wirelessDevicesToAdd);
            this.wirelessDevicesToRemove(model.wirelessDevicesToRemove);
            this.wirelessGatewaysToAdd(model.wirelessGatewaysToAdd);
            this.wirelessGatewaysToRemove(model.wirelessGatewaysToRemove);
            this.description(model.description);
            this.multicastGroupsToAdd(model.multicastGroupsToAdd);
            this.multicastGroupsToRemove(model.multicastGroupsToRemove);
        }

        public final String getConfigurationName() {
            return this.configurationName;
        }

        public final void setConfigurationName(String configurationName) {
            this.configurationName = configurationName;
        }

        @Override
        public final Builder configurationName(String configurationName) {
            this.configurationName = configurationName;
            return this;
        }

        public final TraceContent.Builder getTraceContent() {
            return this.traceContent != null ? this.traceContent.toBuilder() : null;
        }

        public final void setTraceContent(TraceContent.BuilderImpl traceContent) {
            this.traceContent = traceContent != null ? traceContent.build() : null;
        }

        @Override
        public final Builder traceContent(TraceContent traceContent) {
            this.traceContent = traceContent;
            return this;
        }

        public final Collection<String> getWirelessDevicesToAdd() {
            if (this.wirelessDevicesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessDevicesToAdd;
        }

        public final void setWirelessDevicesToAdd(Collection<String> wirelessDevicesToAdd) {
            this.wirelessDevicesToAdd = WirelessDeviceListCopier.copy(wirelessDevicesToAdd);
        }

        @Override
        public final Builder wirelessDevicesToAdd(Collection<String> wirelessDevicesToAdd) {
            this.wirelessDevicesToAdd = WirelessDeviceListCopier.copy(wirelessDevicesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevicesToAdd(String ... wirelessDevicesToAdd) {
            this.wirelessDevicesToAdd(Arrays.asList(wirelessDevicesToAdd));
            return this;
        }

        public final Collection<String> getWirelessDevicesToRemove() {
            if (this.wirelessDevicesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessDevicesToRemove;
        }

        public final void setWirelessDevicesToRemove(Collection<String> wirelessDevicesToRemove) {
            this.wirelessDevicesToRemove = WirelessDeviceListCopier.copy(wirelessDevicesToRemove);
        }

        @Override
        public final Builder wirelessDevicesToRemove(Collection<String> wirelessDevicesToRemove) {
            this.wirelessDevicesToRemove = WirelessDeviceListCopier.copy(wirelessDevicesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessDevicesToRemove(String ... wirelessDevicesToRemove) {
            this.wirelessDevicesToRemove(Arrays.asList(wirelessDevicesToRemove));
            return this;
        }

        public final Collection<String> getWirelessGatewaysToAdd() {
            if (this.wirelessGatewaysToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessGatewaysToAdd;
        }

        public final void setWirelessGatewaysToAdd(Collection<String> wirelessGatewaysToAdd) {
            this.wirelessGatewaysToAdd = WirelessGatewayListCopier.copy(wirelessGatewaysToAdd);
        }

        @Override
        public final Builder wirelessGatewaysToAdd(Collection<String> wirelessGatewaysToAdd) {
            this.wirelessGatewaysToAdd = WirelessGatewayListCopier.copy(wirelessGatewaysToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewaysToAdd(String ... wirelessGatewaysToAdd) {
            this.wirelessGatewaysToAdd(Arrays.asList(wirelessGatewaysToAdd));
            return this;
        }

        public final Collection<String> getWirelessGatewaysToRemove() {
            if (this.wirelessGatewaysToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.wirelessGatewaysToRemove;
        }

        public final void setWirelessGatewaysToRemove(Collection<String> wirelessGatewaysToRemove) {
            this.wirelessGatewaysToRemove = WirelessGatewayListCopier.copy(wirelessGatewaysToRemove);
        }

        @Override
        public final Builder wirelessGatewaysToRemove(Collection<String> wirelessGatewaysToRemove) {
            this.wirelessGatewaysToRemove = WirelessGatewayListCopier.copy(wirelessGatewaysToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wirelessGatewaysToRemove(String ... wirelessGatewaysToRemove) {
            this.wirelessGatewaysToRemove(Arrays.asList(wirelessGatewaysToRemove));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getMulticastGroupsToAdd() {
            if (this.multicastGroupsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.multicastGroupsToAdd;
        }

        public final void setMulticastGroupsToAdd(Collection<String> multicastGroupsToAdd) {
            this.multicastGroupsToAdd = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroupsToAdd);
        }

        @Override
        public final Builder multicastGroupsToAdd(Collection<String> multicastGroupsToAdd) {
            this.multicastGroupsToAdd = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroupsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupsToAdd(String ... multicastGroupsToAdd) {
            this.multicastGroupsToAdd(Arrays.asList(multicastGroupsToAdd));
            return this;
        }

        public final Collection<String> getMulticastGroupsToRemove() {
            if (this.multicastGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.multicastGroupsToRemove;
        }

        public final void setMulticastGroupsToRemove(Collection<String> multicastGroupsToRemove) {
            this.multicastGroupsToRemove = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroupsToRemove);
        }

        @Override
        public final Builder multicastGroupsToRemove(Collection<String> multicastGroupsToRemove) {
            this.multicastGroupsToRemove = NetworkAnalyzerMulticastGroupListCopier.copy(multicastGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupsToRemove(String ... multicastGroupsToRemove) {
            this.multicastGroupsToRemove(Arrays.asList(multicastGroupsToRemove));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNetworkAnalyzerConfigurationRequest build() {
            return new UpdateNetworkAnalyzerConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateNetworkAnalyzerConfigurationRequest> {
        public Builder configurationName(String var1);

        public Builder traceContent(TraceContent var1);

        default public Builder traceContent(Consumer<TraceContent.Builder> traceContent) {
            return this.traceContent((TraceContent)((TraceContent.Builder)TraceContent.builder().applyMutation(traceContent)).build());
        }

        public Builder wirelessDevicesToAdd(Collection<String> var1);

        public Builder wirelessDevicesToAdd(String ... var1);

        public Builder wirelessDevicesToRemove(Collection<String> var1);

        public Builder wirelessDevicesToRemove(String ... var1);

        public Builder wirelessGatewaysToAdd(Collection<String> var1);

        public Builder wirelessGatewaysToAdd(String ... var1);

        public Builder wirelessGatewaysToRemove(Collection<String> var1);

        public Builder wirelessGatewaysToRemove(String ... var1);

        public Builder description(String var1);

        public Builder multicastGroupsToAdd(Collection<String> var1);

        public Builder multicastGroupsToAdd(String ... var1);

        public Builder multicastGroupsToRemove(Collection<String> var1);

        public Builder multicastGroupsToRemove(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

