/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.MulticastGroupByFuotaTask;
import software.amazon.awssdk.services.iotwireless.model.MulticastGroupListByFuotaTaskCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMulticastGroupsByFuotaTaskResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, ListMulticastGroupsByFuotaTaskResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMulticastGroupsByFuotaTaskResponse.getter(ListMulticastGroupsByFuotaTaskResponse::nextToken)).setter(ListMulticastGroupsByFuotaTaskResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MulticastGroupByFuotaTask>> MULTICAST_GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MulticastGroupList").getter(ListMulticastGroupsByFuotaTaskResponse.getter(ListMulticastGroupsByFuotaTaskResponse::multicastGroupList)).setter(ListMulticastGroupsByFuotaTaskResponse.setter(Builder::multicastGroupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastGroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MulticastGroupByFuotaTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MULTICAST_GROUP_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListMulticastGroupsByFuotaTaskResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<MulticastGroupByFuotaTask> multicastGroupList;

    private ListMulticastGroupsByFuotaTaskResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.multicastGroupList = builder.multicastGroupList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasMulticastGroupList() {
        return this.multicastGroupList != null && !(this.multicastGroupList instanceof SdkAutoConstructList);
    }

    public final List<MulticastGroupByFuotaTask> multicastGroupList() {
        return this.multicastGroupList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMulticastGroupList() ? this.multicastGroupList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMulticastGroupsByFuotaTaskResponse)) {
            return false;
        }
        ListMulticastGroupsByFuotaTaskResponse other = (ListMulticastGroupsByFuotaTaskResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasMulticastGroupList() == other.hasMulticastGroupList() && Objects.equals(this.multicastGroupList(), other.multicastGroupList());
    }

    public final String toString() {
        return ToString.builder((String)"ListMulticastGroupsByFuotaTaskResponse").add("NextToken", (Object)this.nextToken()).add("MulticastGroupList", this.hasMulticastGroupList() ? this.multicastGroupList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MulticastGroupList": {
                return Optional.ofNullable(clazz.cast(this.multicastGroupList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MulticastGroupList", MULTICAST_GROUP_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMulticastGroupsByFuotaTaskResponse, T> g) {
        return obj -> g.apply((ListMulticastGroupsByFuotaTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MulticastGroupByFuotaTask> multicastGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMulticastGroupsByFuotaTaskResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.multicastGroupList(model.multicastGroupList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MulticastGroupByFuotaTask.Builder> getMulticastGroupList() {
            List<MulticastGroupByFuotaTask.Builder> result = MulticastGroupListByFuotaTaskCopier.copyToBuilder(this.multicastGroupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMulticastGroupList(Collection<MulticastGroupByFuotaTask.BuilderImpl> multicastGroupList) {
            this.multicastGroupList = MulticastGroupListByFuotaTaskCopier.copyFromBuilder(multicastGroupList);
        }

        @Override
        public final Builder multicastGroupList(Collection<MulticastGroupByFuotaTask> multicastGroupList) {
            this.multicastGroupList = MulticastGroupListByFuotaTaskCopier.copy(multicastGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupList(MulticastGroupByFuotaTask ... multicastGroupList) {
            this.multicastGroupList(Arrays.asList(multicastGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder multicastGroupList(Consumer<MulticastGroupByFuotaTask.Builder> ... multicastGroupList) {
            this.multicastGroupList(Stream.of(multicastGroupList).map(c -> (MulticastGroupByFuotaTask)((MulticastGroupByFuotaTask.Builder)MulticastGroupByFuotaTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMulticastGroupsByFuotaTaskResponse build() {
            return new ListMulticastGroupsByFuotaTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMulticastGroupsByFuotaTaskResponse> {
        public Builder nextToken(String var1);

        public Builder multicastGroupList(Collection<MulticastGroupByFuotaTask> var1);

        public Builder multicastGroupList(MulticastGroupByFuotaTask ... var1);

        public Builder multicastGroupList(Consumer<MulticastGroupByFuotaTask.Builder> ... var1);
    }
}

