/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.FuotaDeviceStatus;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANListDevice;
import software.amazon.awssdk.services.iotwireless.model.SidewalkListDevice;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WirelessDeviceStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WirelessDeviceStatistics> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::arn)).setter(WirelessDeviceStatistics.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::id)).setter(WirelessDeviceStatistics.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::typeAsString)).setter(WirelessDeviceStatistics.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::name)).setter(WirelessDeviceStatistics.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::destinationName)).setter(WirelessDeviceStatistics.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> LAST_UPLINK_RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastUplinkReceivedAt").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::lastUplinkReceivedAt)).setter(WirelessDeviceStatistics.setter(Builder::lastUplinkReceivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUplinkReceivedAt").build()}).build();
    private static final SdkField<LoRaWANListDevice> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::loRaWAN)).setter(WirelessDeviceStatistics.setter(Builder::loRaWAN)).constructor(LoRaWANListDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<SidewalkListDevice> SIDEWALK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sidewalk").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::sidewalk)).setter(WirelessDeviceStatistics.setter(Builder::sidewalk)).constructor(SidewalkListDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sidewalk").build()}).build();
    private static final SdkField<String> FUOTA_DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FuotaDeviceStatus").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::fuotaDeviceStatusAsString)).setter(WirelessDeviceStatistics.setter(Builder::fuotaDeviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuotaDeviceStatus").build()}).build();
    private static final SdkField<String> MULTICAST_DEVICE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MulticastDeviceStatus").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::multicastDeviceStatus)).setter(WirelessDeviceStatistics.setter(Builder::multicastDeviceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastDeviceStatus").build()}).build();
    private static final SdkField<Integer> MC_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("McGroupId").getter(WirelessDeviceStatistics.getter(WirelessDeviceStatistics::mcGroupId)).setter(WirelessDeviceStatistics.setter(Builder::mcGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("McGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, TYPE_FIELD, NAME_FIELD, DESTINATION_NAME_FIELD, LAST_UPLINK_RECEIVED_AT_FIELD, LO_RA_WAN_FIELD, SIDEWALK_FIELD, FUOTA_DEVICE_STATUS_FIELD, MULTICAST_DEVICE_STATUS_FIELD, MC_GROUP_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WirelessDeviceStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final String type;
    private final String name;
    private final String destinationName;
    private final String lastUplinkReceivedAt;
    private final LoRaWANListDevice loRaWAN;
    private final SidewalkListDevice sidewalk;
    private final String fuotaDeviceStatus;
    private final String multicastDeviceStatus;
    private final Integer mcGroupId;

    private WirelessDeviceStatistics(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.type = builder.type;
        this.name = builder.name;
        this.destinationName = builder.destinationName;
        this.lastUplinkReceivedAt = builder.lastUplinkReceivedAt;
        this.loRaWAN = builder.loRaWAN;
        this.sidewalk = builder.sidewalk;
        this.fuotaDeviceStatus = builder.fuotaDeviceStatus;
        this.multicastDeviceStatus = builder.multicastDeviceStatus;
        this.mcGroupId = builder.mcGroupId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final WirelessDeviceType type() {
        return WirelessDeviceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final String lastUplinkReceivedAt() {
        return this.lastUplinkReceivedAt;
    }

    public final LoRaWANListDevice loRaWAN() {
        return this.loRaWAN;
    }

    public final SidewalkListDevice sidewalk() {
        return this.sidewalk;
    }

    public final FuotaDeviceStatus fuotaDeviceStatus() {
        return FuotaDeviceStatus.fromValue(this.fuotaDeviceStatus);
    }

    public final String fuotaDeviceStatusAsString() {
        return this.fuotaDeviceStatus;
    }

    public final String multicastDeviceStatus() {
        return this.multicastDeviceStatus;
    }

    public final Integer mcGroupId() {
        return this.mcGroupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUplinkReceivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.sidewalk());
        hashCode = 31 * hashCode + Objects.hashCode(this.fuotaDeviceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.multicastDeviceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcGroupId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WirelessDeviceStatistics)) {
            return false;
        }
        WirelessDeviceStatistics other = (WirelessDeviceStatistics)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.lastUplinkReceivedAt(), other.lastUplinkReceivedAt()) && Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.sidewalk(), other.sidewalk()) && Objects.equals(this.fuotaDeviceStatusAsString(), other.fuotaDeviceStatusAsString()) && Objects.equals(this.multicastDeviceStatus(), other.multicastDeviceStatus()) && Objects.equals(this.mcGroupId(), other.mcGroupId());
    }

    public final String toString() {
        return ToString.builder((String)"WirelessDeviceStatistics").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("DestinationName", (Object)this.destinationName()).add("LastUplinkReceivedAt", (Object)this.lastUplinkReceivedAt()).add("LoRaWAN", (Object)this.loRaWAN()).add("Sidewalk", (Object)this.sidewalk()).add("FuotaDeviceStatus", (Object)this.fuotaDeviceStatusAsString()).add("MulticastDeviceStatus", (Object)this.multicastDeviceStatus()).add("McGroupId", (Object)this.mcGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "LastUplinkReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUplinkReceivedAt()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "Sidewalk": {
                return Optional.ofNullable(clazz.cast(this.sidewalk()));
            }
            case "FuotaDeviceStatus": {
                return Optional.ofNullable(clazz.cast(this.fuotaDeviceStatusAsString()));
            }
            case "MulticastDeviceStatus": {
                return Optional.ofNullable(clazz.cast(this.multicastDeviceStatus()));
            }
            case "McGroupId": {
                return Optional.ofNullable(clazz.cast(this.mcGroupId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Arn", ARN_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DestinationName", DESTINATION_NAME_FIELD);
        map.put("LastUplinkReceivedAt", LAST_UPLINK_RECEIVED_AT_FIELD);
        map.put("LoRaWAN", LO_RA_WAN_FIELD);
        map.put("Sidewalk", SIDEWALK_FIELD);
        map.put("FuotaDeviceStatus", FUOTA_DEVICE_STATUS_FIELD);
        map.put("MulticastDeviceStatus", MULTICAST_DEVICE_STATUS_FIELD);
        map.put("McGroupId", MC_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WirelessDeviceStatistics, T> g) {
        return obj -> g.apply((WirelessDeviceStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String type;
        private String name;
        private String destinationName;
        private String lastUplinkReceivedAt;
        private LoRaWANListDevice loRaWAN;
        private SidewalkListDevice sidewalk;
        private String fuotaDeviceStatus;
        private String multicastDeviceStatus;
        private Integer mcGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(WirelessDeviceStatistics model) {
            this.arn(model.arn);
            this.id(model.id);
            this.type(model.type);
            this.name(model.name);
            this.destinationName(model.destinationName);
            this.lastUplinkReceivedAt(model.lastUplinkReceivedAt);
            this.loRaWAN(model.loRaWAN);
            this.sidewalk(model.sidewalk);
            this.fuotaDeviceStatus(model.fuotaDeviceStatus);
            this.multicastDeviceStatus(model.multicastDeviceStatus);
            this.mcGroupId(model.mcGroupId);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final String getLastUplinkReceivedAt() {
            return this.lastUplinkReceivedAt;
        }

        public final void setLastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
        }

        @Override
        public final Builder lastUplinkReceivedAt(String lastUplinkReceivedAt) {
            this.lastUplinkReceivedAt = lastUplinkReceivedAt;
            return this;
        }

        public final LoRaWANListDevice.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANListDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANListDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final SidewalkListDevice.Builder getSidewalk() {
            return this.sidewalk != null ? this.sidewalk.toBuilder() : null;
        }

        public final void setSidewalk(SidewalkListDevice.BuilderImpl sidewalk) {
            this.sidewalk = sidewalk != null ? sidewalk.build() : null;
        }

        @Override
        public final Builder sidewalk(SidewalkListDevice sidewalk) {
            this.sidewalk = sidewalk;
            return this;
        }

        public final String getFuotaDeviceStatus() {
            return this.fuotaDeviceStatus;
        }

        public final void setFuotaDeviceStatus(String fuotaDeviceStatus) {
            this.fuotaDeviceStatus = fuotaDeviceStatus;
        }

        @Override
        public final Builder fuotaDeviceStatus(String fuotaDeviceStatus) {
            this.fuotaDeviceStatus = fuotaDeviceStatus;
            return this;
        }

        @Override
        public final Builder fuotaDeviceStatus(FuotaDeviceStatus fuotaDeviceStatus) {
            this.fuotaDeviceStatus(fuotaDeviceStatus == null ? null : fuotaDeviceStatus.toString());
            return this;
        }

        public final String getMulticastDeviceStatus() {
            return this.multicastDeviceStatus;
        }

        public final void setMulticastDeviceStatus(String multicastDeviceStatus) {
            this.multicastDeviceStatus = multicastDeviceStatus;
        }

        @Override
        public final Builder multicastDeviceStatus(String multicastDeviceStatus) {
            this.multicastDeviceStatus = multicastDeviceStatus;
            return this;
        }

        public final Integer getMcGroupId() {
            return this.mcGroupId;
        }

        public final void setMcGroupId(Integer mcGroupId) {
            this.mcGroupId = mcGroupId;
        }

        @Override
        public final Builder mcGroupId(Integer mcGroupId) {
            this.mcGroupId = mcGroupId;
            return this;
        }

        public WirelessDeviceStatistics build() {
            return new WirelessDeviceStatistics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WirelessDeviceStatistics> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(WirelessDeviceType var1);

        public Builder name(String var1);

        public Builder destinationName(String var1);

        public Builder lastUplinkReceivedAt(String var1);

        public Builder loRaWAN(LoRaWANListDevice var1);

        default public Builder loRaWAN(Consumer<LoRaWANListDevice.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANListDevice)((LoRaWANListDevice.Builder)LoRaWANListDevice.builder().applyMutation(loRaWAN)).build());
        }

        public Builder sidewalk(SidewalkListDevice var1);

        default public Builder sidewalk(Consumer<SidewalkListDevice.Builder> sidewalk) {
            return this.sidewalk((SidewalkListDevice)((SidewalkListDevice.Builder)SidewalkListDevice.builder().applyMutation(sidewalk)).build());
        }

        public Builder fuotaDeviceStatus(String var1);

        public Builder fuotaDeviceStatus(FuotaDeviceStatus var1);

        public Builder multicastDeviceStatus(String var1);

        public Builder mcGroupId(Integer var1);
    }
}

