/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.EventNotificationTopicStatus;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANConnectionStatusEventNotificationConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectionStatusEventConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectionStatusEventConfiguration> {
    private static final SdkField<LoRaWANConnectionStatusEventNotificationConfigurations> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(ConnectionStatusEventConfiguration.getter(ConnectionStatusEventConfiguration::loRaWAN)).setter(ConnectionStatusEventConfiguration.setter(Builder::loRaWAN)).constructor(LoRaWANConnectionStatusEventNotificationConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final SdkField<String> WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WirelessGatewayIdEventTopic").getter(ConnectionStatusEventConfiguration.getter(ConnectionStatusEventConfiguration::wirelessGatewayIdEventTopicAsString)).setter(ConnectionStatusEventConfiguration.setter(Builder::wirelessGatewayIdEventTopic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WirelessGatewayIdEventTopic").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LO_RA_WAN_FIELD, WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LoRaWAN", LO_RA_WAN_FIELD);
            this.put("WirelessGatewayIdEventTopic", WIRELESS_GATEWAY_ID_EVENT_TOPIC_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN;
    private final String wirelessGatewayIdEventTopic;

    private ConnectionStatusEventConfiguration(BuilderImpl builder) {
        this.loRaWAN = builder.loRaWAN;
        this.wirelessGatewayIdEventTopic = builder.wirelessGatewayIdEventTopic;
    }

    public final LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN() {
        return this.loRaWAN;
    }

    public final EventNotificationTopicStatus wirelessGatewayIdEventTopic() {
        return EventNotificationTopicStatus.fromValue(this.wirelessGatewayIdEventTopic);
    }

    public final String wirelessGatewayIdEventTopicAsString() {
        return this.wirelessGatewayIdEventTopic;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        hashCode = 31 * hashCode + Objects.hashCode(this.wirelessGatewayIdEventTopicAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionStatusEventConfiguration)) {
            return false;
        }
        ConnectionStatusEventConfiguration other = (ConnectionStatusEventConfiguration)obj;
        return Objects.equals(this.loRaWAN(), other.loRaWAN()) && Objects.equals(this.wirelessGatewayIdEventTopicAsString(), other.wirelessGatewayIdEventTopicAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectionStatusEventConfiguration").add("LoRaWAN", (Object)this.loRaWAN()).add("WirelessGatewayIdEventTopic", (Object)this.wirelessGatewayIdEventTopicAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
            case "WirelessGatewayIdEventTopic": {
                return Optional.ofNullable(clazz.cast(this.wirelessGatewayIdEventTopicAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConnectionStatusEventConfiguration, T> g) {
        return obj -> g.apply((ConnectionStatusEventConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN;
        private String wirelessGatewayIdEventTopic;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectionStatusEventConfiguration model) {
            this.loRaWAN(model.loRaWAN);
            this.wirelessGatewayIdEventTopic(model.wirelessGatewayIdEventTopic);
        }

        public final LoRaWANConnectionStatusEventNotificationConfigurations.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final String getWirelessGatewayIdEventTopic() {
            return this.wirelessGatewayIdEventTopic;
        }

        public final void setWirelessGatewayIdEventTopic(String wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic = wirelessGatewayIdEventTopic;
        }

        @Override
        public final Builder wirelessGatewayIdEventTopic(String wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic = wirelessGatewayIdEventTopic;
            return this;
        }

        @Override
        public final Builder wirelessGatewayIdEventTopic(EventNotificationTopicStatus wirelessGatewayIdEventTopic) {
            this.wirelessGatewayIdEventTopic(wirelessGatewayIdEventTopic == null ? null : wirelessGatewayIdEventTopic.toString());
            return this;
        }

        public ConnectionStatusEventConfiguration build() {
            return new ConnectionStatusEventConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectionStatusEventConfiguration> {
        public Builder loRaWAN(LoRaWANConnectionStatusEventNotificationConfigurations var1);

        default public Builder loRaWAN(Consumer<LoRaWANConnectionStatusEventNotificationConfigurations.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANConnectionStatusEventNotificationConfigurations)((LoRaWANConnectionStatusEventNotificationConfigurations.Builder)LoRaWANConnectionStatusEventNotificationConfigurations.builder().applyMutation(loRaWAN)).build());
        }

        public Builder wirelessGatewayIdEventTopic(String var1);

        public Builder wirelessGatewayIdEventTopic(EventNotificationTopicStatus var1);
    }
}

