/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.CellTowers;
import software.amazon.awssdk.services.iotwireless.model.Gnss;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessRequest;
import software.amazon.awssdk.services.iotwireless.model.Ip;
import software.amazon.awssdk.services.iotwireless.model.WiFiAccessPoint;
import software.amazon.awssdk.services.iotwireless.model.WiFiAccessPointsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPositionEstimateRequest
extends IotWirelessRequest
implements ToCopyableBuilder<Builder, GetPositionEstimateRequest> {
    private static final SdkField<List<WiFiAccessPoint>> WI_FI_ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("WiFiAccessPoints").getter(GetPositionEstimateRequest.getter(GetPositionEstimateRequest::wiFiAccessPoints)).setter(GetPositionEstimateRequest.setter(Builder::wiFiAccessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WiFiAccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WiFiAccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<CellTowers> CELL_TOWERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CellTowers").getter(GetPositionEstimateRequest.getter(GetPositionEstimateRequest::cellTowers)).setter(GetPositionEstimateRequest.setter(Builder::cellTowers)).constructor(CellTowers::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellTowers").build()}).build();
    private static final SdkField<Ip> IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ip").getter(GetPositionEstimateRequest.getter(GetPositionEstimateRequest::ip)).setter(GetPositionEstimateRequest.setter(Builder::ip)).constructor(Ip::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ip").build()}).build();
    private static final SdkField<Gnss> GNSS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Gnss").getter(GetPositionEstimateRequest.getter(GetPositionEstimateRequest::gnss)).setter(GetPositionEstimateRequest.setter(Builder::gnss)).constructor(Gnss::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gnss").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(GetPositionEstimateRequest.getter(GetPositionEstimateRequest::timestamp)).setter(GetPositionEstimateRequest.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WI_FI_ACCESS_POINTS_FIELD, CELL_TOWERS_FIELD, IP_FIELD, GNSS_FIELD, TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("WiFiAccessPoints", WI_FI_ACCESS_POINTS_FIELD);
            this.put("CellTowers", CELL_TOWERS_FIELD);
            this.put("Ip", IP_FIELD);
            this.put("Gnss", GNSS_FIELD);
            this.put("Timestamp", TIMESTAMP_FIELD);
        }
    });
    private final List<WiFiAccessPoint> wiFiAccessPoints;
    private final CellTowers cellTowers;
    private final Ip ip;
    private final Gnss gnss;
    private final Instant timestamp;

    private GetPositionEstimateRequest(BuilderImpl builder) {
        super(builder);
        this.wiFiAccessPoints = builder.wiFiAccessPoints;
        this.cellTowers = builder.cellTowers;
        this.ip = builder.ip;
        this.gnss = builder.gnss;
        this.timestamp = builder.timestamp;
    }

    public final boolean hasWiFiAccessPoints() {
        return this.wiFiAccessPoints != null && !(this.wiFiAccessPoints instanceof SdkAutoConstructList);
    }

    public final List<WiFiAccessPoint> wiFiAccessPoints() {
        return this.wiFiAccessPoints;
    }

    public final CellTowers cellTowers() {
        return this.cellTowers;
    }

    public final Ip ip() {
        return this.ip;
    }

    public final Gnss gnss() {
        return this.gnss;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWiFiAccessPoints() ? this.wiFiAccessPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cellTowers());
        hashCode = 31 * hashCode + Objects.hashCode(this.ip());
        hashCode = 31 * hashCode + Objects.hashCode(this.gnss());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionEstimateRequest)) {
            return false;
        }
        GetPositionEstimateRequest other = (GetPositionEstimateRequest)((Object)obj);
        return this.hasWiFiAccessPoints() == other.hasWiFiAccessPoints() && Objects.equals(this.wiFiAccessPoints(), other.wiFiAccessPoints()) && Objects.equals(this.cellTowers(), other.cellTowers()) && Objects.equals(this.ip(), other.ip()) && Objects.equals(this.gnss(), other.gnss()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetPositionEstimateRequest").add("WiFiAccessPoints", this.hasWiFiAccessPoints() ? this.wiFiAccessPoints() : null).add("CellTowers", (Object)this.cellTowers()).add("Ip", (Object)this.ip()).add("Gnss", (Object)this.gnss()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WiFiAccessPoints": {
                return Optional.ofNullable(clazz.cast(this.wiFiAccessPoints()));
            }
            case "CellTowers": {
                return Optional.ofNullable(clazz.cast(this.cellTowers()));
            }
            case "Ip": {
                return Optional.ofNullable(clazz.cast(this.ip()));
            }
            case "Gnss": {
                return Optional.ofNullable(clazz.cast(this.gnss()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetPositionEstimateRequest, T> g) {
        return obj -> g.apply((GetPositionEstimateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessRequest.BuilderImpl
    implements Builder {
        private List<WiFiAccessPoint> wiFiAccessPoints = DefaultSdkAutoConstructList.getInstance();
        private CellTowers cellTowers;
        private Ip ip;
        private Gnss gnss;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionEstimateRequest model) {
            super(model);
            this.wiFiAccessPoints(model.wiFiAccessPoints);
            this.cellTowers(model.cellTowers);
            this.ip(model.ip);
            this.gnss(model.gnss);
            this.timestamp(model.timestamp);
        }

        public final List<WiFiAccessPoint.Builder> getWiFiAccessPoints() {
            List<WiFiAccessPoint.Builder> result = WiFiAccessPointsCopier.copyToBuilder(this.wiFiAccessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWiFiAccessPoints(Collection<WiFiAccessPoint.BuilderImpl> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointsCopier.copyFromBuilder(wiFiAccessPoints);
        }

        @Override
        public final Builder wiFiAccessPoints(Collection<WiFiAccessPoint> wiFiAccessPoints) {
            this.wiFiAccessPoints = WiFiAccessPointsCopier.copy(wiFiAccessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(WiFiAccessPoint ... wiFiAccessPoints) {
            this.wiFiAccessPoints(Arrays.asList(wiFiAccessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder> ... wiFiAccessPoints) {
            this.wiFiAccessPoints(Stream.of(wiFiAccessPoints).map(c -> (WiFiAccessPoint)((WiFiAccessPoint.Builder)WiFiAccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final CellTowers.Builder getCellTowers() {
            return this.cellTowers != null ? this.cellTowers.toBuilder() : null;
        }

        public final void setCellTowers(CellTowers.BuilderImpl cellTowers) {
            this.cellTowers = cellTowers != null ? cellTowers.build() : null;
        }

        @Override
        public final Builder cellTowers(CellTowers cellTowers) {
            this.cellTowers = cellTowers;
            return this;
        }

        public final Ip.Builder getIp() {
            return this.ip != null ? this.ip.toBuilder() : null;
        }

        public final void setIp(Ip.BuilderImpl ip) {
            this.ip = ip != null ? ip.build() : null;
        }

        @Override
        public final Builder ip(Ip ip) {
            this.ip = ip;
            return this;
        }

        public final Gnss.Builder getGnss() {
            return this.gnss != null ? this.gnss.toBuilder() : null;
        }

        public final void setGnss(Gnss.BuilderImpl gnss) {
            this.gnss = gnss != null ? gnss.build() : null;
        }

        @Override
        public final Builder gnss(Gnss gnss) {
            this.gnss = gnss;
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPositionEstimateRequest build() {
            return new GetPositionEstimateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IotWirelessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPositionEstimateRequest> {
        public Builder wiFiAccessPoints(Collection<WiFiAccessPoint> var1);

        public Builder wiFiAccessPoints(WiFiAccessPoint ... var1);

        public Builder wiFiAccessPoints(Consumer<WiFiAccessPoint.Builder> ... var1);

        public Builder cellTowers(CellTowers var1);

        default public Builder cellTowers(Consumer<CellTowers.Builder> cellTowers) {
            return this.cellTowers((CellTowers)((CellTowers.Builder)CellTowers.builder().applyMutation(cellTowers)).build());
        }

        public Builder ip(Ip var1);

        default public Builder ip(Consumer<Ip.Builder> ip) {
            return this.ip((Ip)((Ip.Builder)Ip.builder().applyMutation(ip)).build());
        }

        public Builder gnss(Gnss var1);

        default public Builder gnss(Consumer<Gnss.Builder> gnss) {
            return this.gnss((Gnss)((Gnss.Builder)Gnss.builder().applyMutation(gnss)).build());
        }

        public Builder timestamp(Instant var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

