/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListQueuedMessagesResponse;

public class ListQueuedMessagesPublisher
implements SdkPublisher<ListQueuedMessagesResponse> {
    private final IotWirelessAsyncClient client;
    private final ListQueuedMessagesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListQueuedMessagesPublisher(IotWirelessAsyncClient client, ListQueuedMessagesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListQueuedMessagesPublisher(IotWirelessAsyncClient client, ListQueuedMessagesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListQueuedMessagesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListQueuedMessagesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListQueuedMessagesResponseFetcher
    implements AsyncPageFetcher<ListQueuedMessagesResponse> {
        private ListQueuedMessagesResponseFetcher() {
        }

        public boolean hasNextPage(ListQueuedMessagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListQueuedMessagesResponse> nextPage(ListQueuedMessagesResponse previousPage) {
            if (previousPage == null) {
                return ListQueuedMessagesPublisher.this.client.listQueuedMessages(ListQueuedMessagesPublisher.this.firstRequest);
            }
            return ListQueuedMessagesPublisher.this.client.listQueuedMessages((ListQueuedMessagesRequest)((Object)ListQueuedMessagesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

