/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.PositionSolverDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPositionConfigurationResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetPositionConfigurationResponse> {
    private static final SdkField<PositionSolverDetails> SOLVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Solvers").getter(GetPositionConfigurationResponse.getter(GetPositionConfigurationResponse::solvers)).setter(GetPositionConfigurationResponse.setter(Builder::solvers)).constructor(PositionSolverDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solvers").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(GetPositionConfigurationResponse.getter(GetPositionConfigurationResponse::destination)).setter(GetPositionConfigurationResponse.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOLVERS_FIELD, DESTINATION_FIELD));
    private final PositionSolverDetails solvers;
    private final String destination;

    private GetPositionConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.solvers = builder.solvers;
        this.destination = builder.destination;
    }

    public final PositionSolverDetails solvers() {
        return this.solvers;
    }

    public final String destination() {
        return this.destination;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.solvers());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPositionConfigurationResponse)) {
            return false;
        }
        GetPositionConfigurationResponse other = (GetPositionConfigurationResponse)((Object)obj);
        return Objects.equals(this.solvers(), other.solvers()) && Objects.equals(this.destination(), other.destination());
    }

    public final String toString() {
        return ToString.builder((String)"GetPositionConfigurationResponse").add("Solvers", (Object)this.solvers()).add("Destination", (Object)this.destination()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Solvers": {
                return Optional.ofNullable(clazz.cast(this.solvers()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPositionConfigurationResponse, T> g) {
        return obj -> g.apply((GetPositionConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private PositionSolverDetails solvers;
        private String destination;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPositionConfigurationResponse model) {
            super(model);
            this.solvers(model.solvers);
            this.destination(model.destination);
        }

        public final PositionSolverDetails.Builder getSolvers() {
            return this.solvers != null ? this.solvers.toBuilder() : null;
        }

        public final void setSolvers(PositionSolverDetails.BuilderImpl solvers) {
            this.solvers = solvers != null ? solvers.build() : null;
        }

        @Override
        public final Builder solvers(PositionSolverDetails solvers) {
            this.solvers = solvers;
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public GetPositionConfigurationResponse build() {
            return new GetPositionConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPositionConfigurationResponse> {
        public Builder solvers(PositionSolverDetails var1);

        default public Builder solvers(Consumer<PositionSolverDetails.Builder> solvers) {
            return this.solvers((PositionSolverDetails)((PositionSolverDetails.Builder)PositionSolverDetails.builder().applyMutation(solvers)).build());
        }

        public Builder destination(String var1);
    }
}

