/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotwireless.DefaultIotWirelessBaseClientBuilder;
import software.amazon.awssdk.services.iotwireless.DefaultIotWirelessClient;
import software.amazon.awssdk.services.iotwireless.IotWirelessClient;
import software.amazon.awssdk.services.iotwireless.IotWirelessClientBuilder;
import software.amazon.awssdk.services.iotwireless.IotWirelessServiceClientConfiguration;
import software.amazon.awssdk.services.iotwireless.endpoints.IotWirelessEndpointProvider;

@SdkInternalApi
final class DefaultIotWirelessClientBuilder
extends DefaultIotWirelessBaseClientBuilder<IotWirelessClientBuilder, IotWirelessClient>
implements IotWirelessClientBuilder {
    DefaultIotWirelessClientBuilder() {
    }

    @Override
    public DefaultIotWirelessClientBuilder endpointProvider(IotWirelessEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotWirelessClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotWirelessClientBuilder.validateClientOptions(clientConfiguration);
        IotWirelessServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultIotWirelessClient client = new DefaultIotWirelessClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private IotWirelessServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return IotWirelessServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

