/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadata;
import software.amazon.awssdk.services.iotwireless.model.DakCertificateMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SidewalkGetDeviceProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SidewalkGetDeviceProfile> {
    private static final SdkField<String> APPLICATION_SERVER_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationServerPublicKey").getter(SidewalkGetDeviceProfile.getter(SidewalkGetDeviceProfile::applicationServerPublicKey)).setter(SidewalkGetDeviceProfile.setter(Builder::applicationServerPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationServerPublicKey").build()}).build();
    private static final SdkField<Boolean> QUALIFICATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("QualificationStatus").getter(SidewalkGetDeviceProfile.getter(SidewalkGetDeviceProfile::qualificationStatus)).setter(SidewalkGetDeviceProfile.setter(Builder::qualificationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationStatus").build()}).build();
    private static final SdkField<List<DakCertificateMetadata>> DAK_CERTIFICATE_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DakCertificateMetadata").getter(SidewalkGetDeviceProfile.getter(SidewalkGetDeviceProfile::dakCertificateMetadata)).setter(SidewalkGetDeviceProfile.setter(Builder::dakCertificateMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DakCertificateMetadata").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DakCertificateMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SERVER_PUBLIC_KEY_FIELD, QUALIFICATION_STATUS_FIELD, DAK_CERTIFICATE_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String applicationServerPublicKey;
    private final Boolean qualificationStatus;
    private final List<DakCertificateMetadata> dakCertificateMetadata;

    private SidewalkGetDeviceProfile(BuilderImpl builder) {
        this.applicationServerPublicKey = builder.applicationServerPublicKey;
        this.qualificationStatus = builder.qualificationStatus;
        this.dakCertificateMetadata = builder.dakCertificateMetadata;
    }

    public final String applicationServerPublicKey() {
        return this.applicationServerPublicKey;
    }

    public final Boolean qualificationStatus() {
        return this.qualificationStatus;
    }

    public final boolean hasDakCertificateMetadata() {
        return this.dakCertificateMetadata != null && !(this.dakCertificateMetadata instanceof SdkAutoConstructList);
    }

    public final List<DakCertificateMetadata> dakCertificateMetadata() {
        return this.dakCertificateMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationServerPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDakCertificateMetadata() ? this.dakCertificateMetadata() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SidewalkGetDeviceProfile)) {
            return false;
        }
        SidewalkGetDeviceProfile other = (SidewalkGetDeviceProfile)obj;
        return Objects.equals(this.applicationServerPublicKey(), other.applicationServerPublicKey()) && Objects.equals(this.qualificationStatus(), other.qualificationStatus()) && this.hasDakCertificateMetadata() == other.hasDakCertificateMetadata() && Objects.equals(this.dakCertificateMetadata(), other.dakCertificateMetadata());
    }

    public final String toString() {
        return ToString.builder((String)"SidewalkGetDeviceProfile").add("ApplicationServerPublicKey", (Object)(this.applicationServerPublicKey() == null ? null : "*** Sensitive Data Redacted ***")).add("QualificationStatus", (Object)this.qualificationStatus()).add("DakCertificateMetadata", this.hasDakCertificateMetadata() ? this.dakCertificateMetadata() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationServerPublicKey": {
                return Optional.ofNullable(clazz.cast(this.applicationServerPublicKey()));
            }
            case "QualificationStatus": {
                return Optional.ofNullable(clazz.cast(this.qualificationStatus()));
            }
            case "DakCertificateMetadata": {
                return Optional.ofNullable(clazz.cast(this.dakCertificateMetadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SidewalkGetDeviceProfile, T> g) {
        return obj -> g.apply((SidewalkGetDeviceProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationServerPublicKey;
        private Boolean qualificationStatus;
        private List<DakCertificateMetadata> dakCertificateMetadata = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SidewalkGetDeviceProfile model) {
            this.applicationServerPublicKey(model.applicationServerPublicKey);
            this.qualificationStatus(model.qualificationStatus);
            this.dakCertificateMetadata(model.dakCertificateMetadata);
        }

        public final String getApplicationServerPublicKey() {
            return this.applicationServerPublicKey;
        }

        public final void setApplicationServerPublicKey(String applicationServerPublicKey) {
            this.applicationServerPublicKey = applicationServerPublicKey;
        }

        @Override
        public final Builder applicationServerPublicKey(String applicationServerPublicKey) {
            this.applicationServerPublicKey = applicationServerPublicKey;
            return this;
        }

        public final Boolean getQualificationStatus() {
            return this.qualificationStatus;
        }

        public final void setQualificationStatus(Boolean qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
        }

        @Override
        public final Builder qualificationStatus(Boolean qualificationStatus) {
            this.qualificationStatus = qualificationStatus;
            return this;
        }

        public final List<DakCertificateMetadata.Builder> getDakCertificateMetadata() {
            List<DakCertificateMetadata.Builder> result = DakCertificateMetadataListCopier.copyToBuilder(this.dakCertificateMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDakCertificateMetadata(Collection<DakCertificateMetadata.BuilderImpl> dakCertificateMetadata) {
            this.dakCertificateMetadata = DakCertificateMetadataListCopier.copyFromBuilder(dakCertificateMetadata);
        }

        @Override
        public final Builder dakCertificateMetadata(Collection<DakCertificateMetadata> dakCertificateMetadata) {
            this.dakCertificateMetadata = DakCertificateMetadataListCopier.copy(dakCertificateMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dakCertificateMetadata(DakCertificateMetadata ... dakCertificateMetadata) {
            this.dakCertificateMetadata(Arrays.asList(dakCertificateMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dakCertificateMetadata(Consumer<DakCertificateMetadata.Builder> ... dakCertificateMetadata) {
            this.dakCertificateMetadata(Stream.of(dakCertificateMetadata).map(c -> (DakCertificateMetadata)((DakCertificateMetadata.Builder)DakCertificateMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SidewalkGetDeviceProfile build() {
            return new SidewalkGetDeviceProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SidewalkGetDeviceProfile> {
        public Builder applicationServerPublicKey(String var1);

        public Builder qualificationStatus(Boolean var1);

        public Builder dakCertificateMetadata(Collection<DakCertificateMetadata> var1);

        public Builder dakCertificateMetadata(DakCertificateMetadata ... var1);

        public Builder dakCertificateMetadata(Consumer<DakCertificateMetadata.Builder> ... var1);
    }
}

