/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesRequest;
import software.amazon.awssdk.services.iotwireless.model.ListServiceProfilesResponse;

public class ListServiceProfilesPublisher
implements SdkPublisher<ListServiceProfilesResponse> {
    private final IotWirelessAsyncClient client;
    private final ListServiceProfilesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServiceProfilesPublisher(IotWirelessAsyncClient client, ListServiceProfilesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServiceProfilesPublisher(IotWirelessAsyncClient client, ListServiceProfilesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServiceProfilesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServiceProfilesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListServiceProfilesResponseFetcher
    implements AsyncPageFetcher<ListServiceProfilesResponse> {
        private ListServiceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListServiceProfilesResponse> nextPage(ListServiceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListServiceProfilesPublisher.this.client.listServiceProfiles(ListServiceProfilesPublisher.this.firstRequest);
            }
            return ListServiceProfilesPublisher.this.client.listServiceProfiles((ListServiceProfilesRequest)((Object)ListServiceProfilesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

