/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListDestinationsResponse;

public class ListDestinationsPublisher
implements SdkPublisher<ListDestinationsResponse> {
    private final IotWirelessAsyncClient client;
    private final ListDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDestinationsPublisher(IotWirelessAsyncClient client, ListDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDestinationsPublisher(IotWirelessAsyncClient client, ListDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDestinationsResponseFetcher
    implements AsyncPageFetcher<ListDestinationsResponse> {
        private ListDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDestinationsResponse> nextPage(ListDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListDestinationsPublisher.this.client.listDestinations(ListDestinationsPublisher.this.firstRequest);
            }
            return ListDestinationsPublisher.this.client.listDestinations((ListDestinationsRequest)((Object)ListDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

