/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANSendDataToDevice;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DownlinkQueueMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DownlinkQueueMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MessageId").getter(DownlinkQueueMessage.getter(DownlinkQueueMessage::messageId)).setter(DownlinkQueueMessage.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageId").build()}).build();
    private static final SdkField<Integer> TRANSMIT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TransmitMode").getter(DownlinkQueueMessage.getter(DownlinkQueueMessage::transmitMode)).setter(DownlinkQueueMessage.setter(Builder::transmitMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransmitMode").build()}).build();
    private static final SdkField<String> RECEIVED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReceivedAt").getter(DownlinkQueueMessage.getter(DownlinkQueueMessage::receivedAt)).setter(DownlinkQueueMessage.setter(Builder::receivedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceivedAt").build()}).build();
    private static final SdkField<LoRaWANSendDataToDevice> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(DownlinkQueueMessage.getter(DownlinkQueueMessage::loRaWAN)).setter(DownlinkQueueMessage.setter(Builder::loRaWAN)).constructor(LoRaWANSendDataToDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD, TRANSMIT_MODE_FIELD, RECEIVED_AT_FIELD, LO_RA_WAN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String messageId;
    private final Integer transmitMode;
    private final String receivedAt;
    private final LoRaWANSendDataToDevice loRaWAN;

    private DownlinkQueueMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.transmitMode = builder.transmitMode;
        this.receivedAt = builder.receivedAt;
        this.loRaWAN = builder.loRaWAN;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Integer transmitMode() {
        return this.transmitMode;
    }

    public final String receivedAt() {
        return this.receivedAt;
    }

    public final LoRaWANSendDataToDevice loRaWAN() {
        return this.loRaWAN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transmitMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.receivedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DownlinkQueueMessage)) {
            return false;
        }
        DownlinkQueueMessage other = (DownlinkQueueMessage)obj;
        return Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.transmitMode(), other.transmitMode()) && Objects.equals(this.receivedAt(), other.receivedAt()) && Objects.equals(this.loRaWAN(), other.loRaWAN());
    }

    public final String toString() {
        return ToString.builder((String)"DownlinkQueueMessage").add("MessageId", (Object)this.messageId()).add("TransmitMode", (Object)this.transmitMode()).add("ReceivedAt", (Object)this.receivedAt()).add("LoRaWAN", (Object)this.loRaWAN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MessageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "TransmitMode": {
                return Optional.ofNullable(clazz.cast(this.transmitMode()));
            }
            case "ReceivedAt": {
                return Optional.ofNullable(clazz.cast(this.receivedAt()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DownlinkQueueMessage, T> g) {
        return obj -> g.apply((DownlinkQueueMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String messageId;
        private Integer transmitMode;
        private String receivedAt;
        private LoRaWANSendDataToDevice loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(DownlinkQueueMessage model) {
            this.messageId(model.messageId);
            this.transmitMode(model.transmitMode);
            this.receivedAt(model.receivedAt);
            this.loRaWAN(model.loRaWAN);
        }

        public final String getMessageId() {
            return this.messageId;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        @Override
        @Transient
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final Integer getTransmitMode() {
            return this.transmitMode;
        }

        public final void setTransmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
        }

        @Override
        @Transient
        public final Builder transmitMode(Integer transmitMode) {
            this.transmitMode = transmitMode;
            return this;
        }

        public final String getReceivedAt() {
            return this.receivedAt;
        }

        public final void setReceivedAt(String receivedAt) {
            this.receivedAt = receivedAt;
        }

        @Override
        @Transient
        public final Builder receivedAt(String receivedAt) {
            this.receivedAt = receivedAt;
            return this;
        }

        public final LoRaWANSendDataToDevice.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        public final void setLoRaWAN(LoRaWANSendDataToDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        @Transient
        public final Builder loRaWAN(LoRaWANSendDataToDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public DownlinkQueueMessage build() {
            return new DownlinkQueueMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DownlinkQueueMessage> {
        public Builder messageId(String var1);

        public Builder transmitMode(Integer var1);

        public Builder receivedAt(String var1);

        public Builder loRaWAN(LoRaWANSendDataToDevice var1);

        default public Builder loRaWAN(Consumer<LoRaWANSendDataToDevice.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANSendDataToDevice)((LoRaWANSendDataToDevice.Builder)LoRaWANSendDataToDevice.builder().applyMutation(loRaWAN)).build());
        }
    }
}

