/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MessageType {
    CUSTOM_COMMAND_ID_NOTIFY("CUSTOM_COMMAND_ID_NOTIFY"),
    CUSTOM_COMMAND_ID_GET("CUSTOM_COMMAND_ID_GET"),
    CUSTOM_COMMAND_ID_SET("CUSTOM_COMMAND_ID_SET"),
    CUSTOM_COMMAND_ID_RESP("CUSTOM_COMMAND_ID_RESP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MessageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MessageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MessageType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MessageType> knownValues() {
        return Stream.of(MessageType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

