/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SigningAlg {
    ED25519("Ed25519"),
    P256_R1("P256r1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SigningAlg(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SigningAlg fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SigningAlg.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SigningAlg> knownValues() {
        return Stream.of(SigningAlg.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

