/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANGateway> {
    private static final SdkField<String> GATEWAY_EUI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayEui").getter(LoRaWANGateway.getter(LoRaWANGateway::gatewayEui)).setter(LoRaWANGateway.setter(Builder::gatewayEui)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayEui").build()}).build();
    private static final SdkField<String> RF_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RfRegion").getter(LoRaWANGateway.getter(LoRaWANGateway::rfRegion)).setter(LoRaWANGateway.setter(Builder::rfRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RfRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_EUI_FIELD, RF_REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayEui;
    private final String rfRegion;

    private LoRaWANGateway(BuilderImpl builder) {
        this.gatewayEui = builder.gatewayEui;
        this.rfRegion = builder.rfRegion;
    }

    public String gatewayEui() {
        return this.gatewayEui;
    }

    public String rfRegion() {
        return this.rfRegion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayEui());
        hashCode = 31 * hashCode + Objects.hashCode(this.rfRegion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANGateway)) {
            return false;
        }
        LoRaWANGateway other = (LoRaWANGateway)obj;
        return Objects.equals(this.gatewayEui(), other.gatewayEui()) && Objects.equals(this.rfRegion(), other.rfRegion());
    }

    public String toString() {
        return ToString.builder((String)"LoRaWANGateway").add("GatewayEui", (Object)this.gatewayEui()).add("RfRegion", (Object)this.rfRegion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayEui": {
                return Optional.ofNullable(clazz.cast(this.gatewayEui()));
            }
            case "RfRegion": {
                return Optional.ofNullable(clazz.cast(this.rfRegion()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANGateway, T> g) {
        return obj -> g.apply((LoRaWANGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayEui;
        private String rfRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANGateway model) {
            this.gatewayEui(model.gatewayEui);
            this.rfRegion(model.rfRegion);
        }

        public final String getGatewayEui() {
            return this.gatewayEui;
        }

        @Override
        public final Builder gatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
            return this;
        }

        public final void setGatewayEui(String gatewayEui) {
            this.gatewayEui = gatewayEui;
        }

        public final String getRfRegion() {
            return this.rfRegion;
        }

        @Override
        public final Builder rfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
            return this;
        }

        public final void setRfRegion(String rfRegion) {
            this.rfRegion = rfRegion;
        }

        public LoRaWANGateway build() {
            return new LoRaWANGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANGateway> {
        public Builder gatewayEui(String var1);

        public Builder rfRegion(String var1);
    }
}

