/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotwireless.model.IotWirelessResponse;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANDevice;
import software.amazon.awssdk.services.iotwireless.model.WirelessDeviceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWirelessDeviceResponse
extends IotWirelessResponse
implements ToCopyableBuilder<Builder, GetWirelessDeviceResponse> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::typeAsString)).setter(GetWirelessDeviceResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::name)).setter(GetWirelessDeviceResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::description)).setter(GetWirelessDeviceResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationName").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::destinationName)).setter(GetWirelessDeviceResponse.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationName").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::id)).setter(GetWirelessDeviceResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::arn)).setter(GetWirelessDeviceResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThingName").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::thingName)).setter(GetWirelessDeviceResponse.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingName").build()}).build();
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThingArn").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::thingArn)).setter(GetWirelessDeviceResponse.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThingArn").build()}).build();
    private static final SdkField<LoRaWANDevice> LO_RA_WAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoRaWAN").getter(GetWirelessDeviceResponse.getter(GetWirelessDeviceResponse::loRaWAN)).setter(GetWirelessDeviceResponse.setter(Builder::loRaWAN)).constructor(LoRaWANDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoRaWAN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DESTINATION_NAME_FIELD, ID_FIELD, ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD, LO_RA_WAN_FIELD));
    private final String type;
    private final String name;
    private final String description;
    private final String destinationName;
    private final String id;
    private final String arn;
    private final String thingName;
    private final String thingArn;
    private final LoRaWANDevice loRaWAN;

    private GetWirelessDeviceResponse(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.destinationName = builder.destinationName;
        this.id = builder.id;
        this.arn = builder.arn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
        this.loRaWAN = builder.loRaWAN;
    }

    public WirelessDeviceType type() {
        return WirelessDeviceType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String destinationName() {
        return this.destinationName;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingArn() {
        return this.thingArn;
    }

    public LoRaWANDevice loRaWAN() {
        return this.loRaWAN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.loRaWAN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWirelessDeviceResponse)) {
            return false;
        }
        GetWirelessDeviceResponse other = (GetWirelessDeviceResponse)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.loRaWAN(), other.loRaWAN());
    }

    public String toString() {
        return ToString.builder((String)"GetWirelessDeviceResponse").add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DestinationName", (Object)this.destinationName()).add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ThingName", (Object)this.thingName()).add("ThingArn", (Object)this.thingArn()).add("LoRaWAN", (Object)this.loRaWAN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DestinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ThingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "ThingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "LoRaWAN": {
                return Optional.ofNullable(clazz.cast(this.loRaWAN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetWirelessDeviceResponse, T> g) {
        return obj -> g.apply((GetWirelessDeviceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotWirelessResponse.BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String description;
        private String destinationName;
        private String id;
        private String arn;
        private String thingName;
        private String thingArn;
        private LoRaWANDevice loRaWAN;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWirelessDeviceResponse model) {
            super(model);
            this.type(model.type);
            this.name(model.name);
            this.description(model.description);
            this.destinationName(model.destinationName);
            this.id(model.id);
            this.arn(model.arn);
            this.thingName(model.thingName);
            this.thingArn(model.thingArn);
            this.loRaWAN(model.loRaWAN);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WirelessDeviceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final LoRaWANDevice.Builder getLoRaWAN() {
            return this.loRaWAN != null ? this.loRaWAN.toBuilder() : null;
        }

        @Override
        public final Builder loRaWAN(LoRaWANDevice loRaWAN) {
            this.loRaWAN = loRaWAN;
            return this;
        }

        public final void setLoRaWAN(LoRaWANDevice.BuilderImpl loRaWAN) {
            this.loRaWAN = loRaWAN != null ? loRaWAN.build() : null;
        }

        @Override
        public GetWirelessDeviceResponse build() {
            return new GetWirelessDeviceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotWirelessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWirelessDeviceResponse> {
        public Builder type(String var1);

        public Builder type(WirelessDeviceType var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder destinationName(String var1);

        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder thingName(String var1);

        public Builder thingArn(String var1);

        public Builder loRaWAN(LoRaWANDevice var1);

        default public Builder loRaWAN(Consumer<LoRaWANDevice.Builder> loRaWAN) {
            return this.loRaWAN((LoRaWANDevice)((LoRaWANDevice.Builder)LoRaWANDevice.builder().applyMutation(loRaWAN)).build());
        }
    }
}

