/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyLatestValueMapCopier;
import software.amazon.awssdk.services.iottwinmaker.model.TabularPropertyValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPropertyValueResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetPropertyValueResponse> {
    private static final SdkField<Map<String, PropertyLatestValue>> PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("propertyValues").getter(GetPropertyValueResponse.getter(GetPropertyValueResponse::propertyValues)).setter(GetPropertyValueResponse.setter(Builder::propertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyLatestValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetPropertyValueResponse.getter(GetPropertyValueResponse::nextToken)).setter(GetPropertyValueResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<List<Map<String, DataValue>>>> TABULAR_PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tabularPropertyValues").getter(GetPropertyValueResponse.getter(GetPropertyValueResponse::tabularPropertyValues)).setter(GetPropertyValueResponse.setter(Builder::tabularPropertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tabularPropertyValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPERTY_VALUES_FIELD, NEXT_TOKEN_FIELD, TABULAR_PROPERTY_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPropertyValueResponse.memberNameToFieldInitializer();
    private final Map<String, PropertyLatestValue> propertyValues;
    private final String nextToken;
    private final List<List<Map<String, DataValue>>> tabularPropertyValues;

    private GetPropertyValueResponse(BuilderImpl builder) {
        super(builder);
        this.propertyValues = builder.propertyValues;
        this.nextToken = builder.nextToken;
        this.tabularPropertyValues = builder.tabularPropertyValues;
    }

    public final boolean hasPropertyValues() {
        return this.propertyValues != null && !(this.propertyValues instanceof SdkAutoConstructMap);
    }

    public final Map<String, PropertyLatestValue> propertyValues() {
        return this.propertyValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTabularPropertyValues() {
        return this.tabularPropertyValues != null && !(this.tabularPropertyValues instanceof SdkAutoConstructList);
    }

    public final List<List<Map<String, DataValue>>> tabularPropertyValues() {
        return this.tabularPropertyValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyValues() ? this.propertyValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTabularPropertyValues() ? this.tabularPropertyValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPropertyValueResponse)) {
            return false;
        }
        GetPropertyValueResponse other = (GetPropertyValueResponse)((Object)obj);
        return this.hasPropertyValues() == other.hasPropertyValues() && Objects.equals(this.propertyValues(), other.propertyValues()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasTabularPropertyValues() == other.hasTabularPropertyValues() && Objects.equals(this.tabularPropertyValues(), other.tabularPropertyValues());
    }

    public final String toString() {
        return ToString.builder((String)"GetPropertyValueResponse").add("PropertyValues", this.hasPropertyValues() ? this.propertyValues() : null).add("NextToken", (Object)this.nextToken()).add("TabularPropertyValues", this.hasTabularPropertyValues() ? this.tabularPropertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "propertyValues": {
                return Optional.ofNullable(clazz.cast(this.propertyValues()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "tabularPropertyValues": {
                return Optional.ofNullable(clazz.cast(this.tabularPropertyValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("propertyValues", PROPERTY_VALUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("tabularPropertyValues", TABULAR_PROPERTY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPropertyValueResponse, T> g) {
        return obj -> g.apply((GetPropertyValueResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private Map<String, PropertyLatestValue> propertyValues = DefaultSdkAutoConstructMap.getInstance();
        private String nextToken;
        private List<List<Map<String, DataValue>>> tabularPropertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPropertyValueResponse model) {
            super(model);
            this.propertyValues(model.propertyValues);
            this.nextToken(model.nextToken);
            this.tabularPropertyValues(model.tabularPropertyValues);
        }

        public final Map<String, PropertyLatestValue.Builder> getPropertyValues() {
            Map<String, PropertyLatestValue.Builder> result = PropertyLatestValueMapCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Map<String, PropertyLatestValue.BuilderImpl> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copyFromBuilder(propertyValues);
        }

        @Override
        public final Builder propertyValues(Map<String, PropertyLatestValue> propertyValues) {
            this.propertyValues = PropertyLatestValueMapCopier.copy(propertyValues);
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<List<Map<String, DataValue.Builder>>> getTabularPropertyValues() {
            List<List<Map<String, DataValue.Builder>>> result = TabularPropertyValuesCopier.copyToBuilder(this.tabularPropertyValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTabularPropertyValues(Collection<? extends Collection<? extends Map<String, DataValue.BuilderImpl>>> tabularPropertyValues) {
            this.tabularPropertyValues = TabularPropertyValuesCopier.copyFromBuilder(tabularPropertyValues);
        }

        @Override
        public final Builder tabularPropertyValues(Collection<? extends Collection<? extends Map<String, DataValue>>> tabularPropertyValues) {
            this.tabularPropertyValues = TabularPropertyValuesCopier.copy(tabularPropertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tabularPropertyValues(Collection<? extends Map<String, DataValue>> ... tabularPropertyValues) {
            this.tabularPropertyValues((Collection<? extends Collection<? extends Map<String, DataValue>>>)Arrays.asList(tabularPropertyValues));
            return this;
        }

        @Override
        public GetPropertyValueResponse build() {
            return new GetPropertyValueResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPropertyValueResponse> {
        public Builder propertyValues(Map<String, PropertyLatestValue> var1);

        public Builder nextToken(String var1);

        public Builder tabularPropertyValues(Collection<? extends Collection<? extends Map<String, DataValue>>> var1);

        public Builder tabularPropertyValues(Collection<? extends Map<String, DataValue>> ... var1);
    }
}

