/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.PricingPlan;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPricingPlanResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, GetPricingPlanResponse> {
    private static final SdkField<PricingPlan> CURRENT_PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentPricingPlan").getter(GetPricingPlanResponse.getter(GetPricingPlanResponse::currentPricingPlan)).setter(GetPricingPlanResponse.setter(Builder::currentPricingPlan)).constructor(PricingPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentPricingPlan").build()}).build();
    private static final SdkField<PricingPlan> PENDING_PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("pendingPricingPlan").getter(GetPricingPlanResponse.getter(GetPricingPlanResponse::pendingPricingPlan)).setter(GetPricingPlanResponse.setter(Builder::pendingPricingPlan)).constructor(PricingPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingPricingPlan").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_PRICING_PLAN_FIELD, PENDING_PRICING_PLAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPricingPlanResponse.memberNameToFieldInitializer();
    private final PricingPlan currentPricingPlan;
    private final PricingPlan pendingPricingPlan;

    private GetPricingPlanResponse(BuilderImpl builder) {
        super(builder);
        this.currentPricingPlan = builder.currentPricingPlan;
        this.pendingPricingPlan = builder.pendingPricingPlan;
    }

    public final PricingPlan currentPricingPlan() {
        return this.currentPricingPlan;
    }

    public final PricingPlan pendingPricingPlan() {
        return this.pendingPricingPlan;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.currentPricingPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingPricingPlan());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPricingPlanResponse)) {
            return false;
        }
        GetPricingPlanResponse other = (GetPricingPlanResponse)((Object)obj);
        return Objects.equals(this.currentPricingPlan(), other.currentPricingPlan()) && Objects.equals(this.pendingPricingPlan(), other.pendingPricingPlan());
    }

    public final String toString() {
        return ToString.builder((String)"GetPricingPlanResponse").add("CurrentPricingPlan", (Object)this.currentPricingPlan()).add("PendingPricingPlan", (Object)this.pendingPricingPlan()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "currentPricingPlan": {
                return Optional.ofNullable(clazz.cast(this.currentPricingPlan()));
            }
            case "pendingPricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pendingPricingPlan()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<PricingPlan>> map = new HashMap<String, SdkField<PricingPlan>>();
        map.put("currentPricingPlan", CURRENT_PRICING_PLAN_FIELD);
        map.put("pendingPricingPlan", PENDING_PRICING_PLAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPricingPlanResponse, T> g) {
        return obj -> g.apply((GetPricingPlanResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private PricingPlan currentPricingPlan;
        private PricingPlan pendingPricingPlan;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPricingPlanResponse model) {
            super(model);
            this.currentPricingPlan(model.currentPricingPlan);
            this.pendingPricingPlan(model.pendingPricingPlan);
        }

        public final PricingPlan.Builder getCurrentPricingPlan() {
            return this.currentPricingPlan != null ? this.currentPricingPlan.toBuilder() : null;
        }

        public final void setCurrentPricingPlan(PricingPlan.BuilderImpl currentPricingPlan) {
            this.currentPricingPlan = currentPricingPlan != null ? currentPricingPlan.build() : null;
        }

        @Override
        public final Builder currentPricingPlan(PricingPlan currentPricingPlan) {
            this.currentPricingPlan = currentPricingPlan;
            return this;
        }

        public final PricingPlan.Builder getPendingPricingPlan() {
            return this.pendingPricingPlan != null ? this.pendingPricingPlan.toBuilder() : null;
        }

        public final void setPendingPricingPlan(PricingPlan.BuilderImpl pendingPricingPlan) {
            this.pendingPricingPlan = pendingPricingPlan != null ? pendingPricingPlan.build() : null;
        }

        @Override
        public final Builder pendingPricingPlan(PricingPlan pendingPricingPlan) {
            this.pendingPricingPlan = pendingPricingPlan;
            return this;
        }

        @Override
        public GetPricingPlanResponse build() {
            return new GetPricingPlanResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPricingPlanResponse> {
        public Builder currentPricingPlan(PricingPlan var1);

        default public Builder currentPricingPlan(Consumer<PricingPlan.Builder> currentPricingPlan) {
            return this.currentPricingPlan((PricingPlan)((PricingPlan.Builder)PricingPlan.builder().applyMutation(currentPricingPlan)).build());
        }

        public Builder pendingPricingPlan(PricingPlan var1);

        default public Builder pendingPricingPlan(Consumer<PricingPlan.Builder> pendingPricingPlan) {
            return this.pendingPricingPlan((PricingPlan)((PricingPlan.Builder)PricingPlan.builder().applyMutation(pendingPricingPlan)).build());
        }
    }
}

