/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSyncJobRequest
extends IoTTwinMakerRequest
implements ToCopyableBuilder<Builder, GetSyncJobRequest> {
    private static final SdkField<String> SYNC_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("syncSource").getter(GetSyncJobRequest.getter(GetSyncJobRequest::syncSource)).setter(GetSyncJobRequest.setter(Builder::syncSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("syncSource").build()}).build();
    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workspaceId").getter(GetSyncJobRequest.getter(GetSyncJobRequest::workspaceId)).setter(GetSyncJobRequest.setter(Builder::workspaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("workspace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_SOURCE_FIELD, WORKSPACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSyncJobRequest.memberNameToFieldInitializer();
    private final String syncSource;
    private final String workspaceId;

    private GetSyncJobRequest(BuilderImpl builder) {
        super(builder);
        this.syncSource = builder.syncSource;
        this.workspaceId = builder.workspaceId;
    }

    public final String syncSource() {
        return this.syncSource;
    }

    public final String workspaceId() {
        return this.workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.syncSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.workspaceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSyncJobRequest)) {
            return false;
        }
        GetSyncJobRequest other = (GetSyncJobRequest)((Object)obj);
        return Objects.equals(this.syncSource(), other.syncSource()) && Objects.equals(this.workspaceId(), other.workspaceId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSyncJobRequest").add("SyncSource", (Object)this.syncSource()).add("WorkspaceId", (Object)this.workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "syncSource": {
                return Optional.ofNullable(clazz.cast(this.syncSource()));
            }
            case "workspaceId": {
                return Optional.ofNullable(clazz.cast(this.workspaceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("syncSource", SYNC_SOURCE_FIELD);
        map.put("workspace", WORKSPACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSyncJobRequest, T> g) {
        return obj -> g.apply((GetSyncJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerRequest.BuilderImpl
    implements Builder {
        private String syncSource;
        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSyncJobRequest model) {
            super(model);
            this.syncSource(model.syncSource);
            this.workspaceId(model.workspaceId);
        }

        public final String getSyncSource() {
            return this.syncSource;
        }

        public final void setSyncSource(String syncSource) {
            this.syncSource = syncSource;
        }

        @Override
        public final Builder syncSource(String syncSource) {
            this.syncSource = syncSource;
            return this;
        }

        public final String getWorkspaceId() {
            return this.workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSyncJobRequest build() {
            return new GetSyncJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTTwinMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSyncJobRequest> {
        public Builder syncSource(String var1);

        public Builder workspaceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

