/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3SourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3SourceConfiguration> {
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("location").getter(S3SourceConfiguration.getter(S3SourceConfiguration::location)).setter(S3SourceConfiguration.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3SourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String location;

    private S3SourceConfiguration(BuilderImpl builder) {
        this.location = builder.location;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SourceConfiguration)) {
            return false;
        }
        S3SourceConfiguration other = (S3SourceConfiguration)obj;
        return Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"S3SourceConfiguration").add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3SourceConfiguration, T> g) {
        return obj -> g.apply((S3SourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SourceConfiguration model) {
            this.location(model.location);
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public S3SourceConfiguration build() {
            return new S3SourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3SourceConfiguration> {
        public Builder location(String var1);
    }
}

