/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.DataValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyDefinitionResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyResponse> {
    private static final SdkField<PropertyDefinitionResponse> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definition").getter(PropertyResponse.getter(PropertyResponse::definition)).setter(PropertyResponse.setter(Builder::definition)).constructor(PropertyDefinitionResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<DataValue> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(PropertyResponse.getter(PropertyResponse::value)).setter(PropertyResponse.setter(Builder::value)).constructor(DataValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<Boolean> ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("areAllPropertyValuesReturned").getter(PropertyResponse.getter(PropertyResponse::areAllPropertyValuesReturned)).setter(PropertyResponse.setter(Builder::areAllPropertyValuesReturned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areAllPropertyValuesReturned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD, VALUE_FIELD, ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("definition", DEFINITION_FIELD);
            this.put("value", VALUE_FIELD);
            this.put("areAllPropertyValuesReturned", ARE_ALL_PROPERTY_VALUES_RETURNED_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final PropertyDefinitionResponse definition;
    private final DataValue value;
    private final Boolean areAllPropertyValuesReturned;

    private PropertyResponse(BuilderImpl builder) {
        this.definition = builder.definition;
        this.value = builder.value;
        this.areAllPropertyValuesReturned = builder.areAllPropertyValuesReturned;
    }

    public final PropertyDefinitionResponse definition() {
        return this.definition;
    }

    public final DataValue value() {
        return this.value;
    }

    public final Boolean areAllPropertyValuesReturned() {
        return this.areAllPropertyValuesReturned;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.areAllPropertyValuesReturned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyResponse)) {
            return false;
        }
        PropertyResponse other = (PropertyResponse)obj;
        return Objects.equals(this.definition(), other.definition()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.areAllPropertyValuesReturned(), other.areAllPropertyValuesReturned());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyResponse").add("Definition", (Object)this.definition()).add("Value", (Object)this.value()).add("AreAllPropertyValuesReturned", (Object)this.areAllPropertyValuesReturned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "areAllPropertyValuesReturned": {
                return Optional.ofNullable(clazz.cast(this.areAllPropertyValuesReturned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PropertyResponse, T> g) {
        return obj -> g.apply((PropertyResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PropertyDefinitionResponse definition;
        private DataValue value;
        private Boolean areAllPropertyValuesReturned;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyResponse model) {
            this.definition(model.definition);
            this.value(model.value);
            this.areAllPropertyValuesReturned(model.areAllPropertyValuesReturned);
        }

        public final PropertyDefinitionResponse.Builder getDefinition() {
            return this.definition != null ? this.definition.toBuilder() : null;
        }

        public final void setDefinition(PropertyDefinitionResponse.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(PropertyDefinitionResponse definition) {
            this.definition = definition;
            return this;
        }

        public final DataValue.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(DataValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(DataValue value) {
            this.value = value;
            return this;
        }

        public final Boolean getAreAllPropertyValuesReturned() {
            return this.areAllPropertyValuesReturned;
        }

        public final void setAreAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
        }

        @Override
        public final Builder areAllPropertyValuesReturned(Boolean areAllPropertyValuesReturned) {
            this.areAllPropertyValuesReturned = areAllPropertyValuesReturned;
            return this;
        }

        public PropertyResponse build() {
            return new PropertyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyResponse> {
        public Builder definition(PropertyDefinitionResponse var1);

        default public Builder definition(Consumer<PropertyDefinitionResponse.Builder> definition) {
            return this.definition((PropertyDefinitionResponse)((PropertyDefinitionResponse.Builder)PropertyDefinitionResponse.builder().applyMutation(definition)).build());
        }

        public Builder value(DataValue var1);

        default public Builder value(Consumer<DataValue.Builder> value) {
            return this.value((DataValue)((DataValue.Builder)DataValue.builder().applyMutation(value)).build());
        }

        public Builder areAllPropertyValuesReturned(Boolean var1);
    }
}

