/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListEntitiesResponse;

public class ListEntitiesIterable
implements SdkIterable<ListEntitiesResponse> {
    private final IoTTwinMakerClient client;
    private final ListEntitiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEntitiesIterable(IoTTwinMakerClient client, ListEntitiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEntitiesResponseFetcher();
    }

    public Iterator<ListEntitiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEntitiesResponseFetcher
    implements SyncPageFetcher<ListEntitiesResponse> {
        private ListEntitiesResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEntitiesResponse nextPage(ListEntitiesResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesIterable.this.client.listEntities(ListEntitiesIterable.this.firstRequest);
            }
            return ListEntitiesIterable.this.client.listEntities((ListEntitiesRequest)((Object)ListEntitiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

