/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ExecuteQueryResponse;

public class ExecuteQueryIterable
implements SdkIterable<ExecuteQueryResponse> {
    private final IoTTwinMakerClient client;
    private final ExecuteQueryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ExecuteQueryIterable(IoTTwinMakerClient client, ExecuteQueryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ExecuteQueryResponseFetcher();
    }

    public Iterator<ExecuteQueryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ExecuteQueryResponseFetcher
    implements SyncPageFetcher<ExecuteQueryResponse> {
        private ExecuteQueryResponseFetcher() {
        }

        public boolean hasNextPage(ExecuteQueryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ExecuteQueryResponse nextPage(ExecuteQueryResponse previousPage) {
            if (previousPage == null) {
                return ExecuteQueryIterable.this.client.executeQuery(ExecuteQueryIterable.this.firstRequest);
            }
            return ExecuteQueryIterable.this.client.executeQuery((ExecuteQueryRequest)((Object)ExecuteQueryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

