/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListSyncJobsResponse;

public class ListSyncJobsPublisher
implements SdkPublisher<ListSyncJobsResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListSyncJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSyncJobsPublisher(IoTTwinMakerAsyncClient client, ListSyncJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSyncJobsPublisher(IoTTwinMakerAsyncClient client, ListSyncJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSyncJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSyncJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSyncJobsResponseFetcher
    implements AsyncPageFetcher<ListSyncJobsResponse> {
        private ListSyncJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSyncJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSyncJobsResponse> nextPage(ListSyncJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSyncJobsPublisher.this.client.listSyncJobs(ListSyncJobsPublisher.this.firstRequest);
            }
            return ListSyncJobsPublisher.this.client.listSyncJobs((ListSyncJobsRequest)((Object)ListSyncJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

