/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListWorkspacesResponse;

public class ListWorkspacesPublisher
implements SdkPublisher<ListWorkspacesResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListWorkspacesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspacesPublisher(IoTTwinMakerAsyncClient client, ListWorkspacesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspacesPublisher(IoTTwinMakerAsyncClient client, ListWorkspacesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspacesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspacesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListWorkspacesResponseFetcher
    implements AsyncPageFetcher<ListWorkspacesResponse> {
        private ListWorkspacesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspacesResponse> nextPage(ListWorkspacesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspacesPublisher.this.client.listWorkspaces(ListWorkspacesPublisher.this.firstRequest);
            }
            return ListWorkspacesPublisher.this.client.listWorkspaces((ListWorkspacesRequest)((Object)ListWorkspacesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

