/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntitiesFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListEntitiesFilter> {
    private static final SdkField<String> COMPONENT_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentTypeId").getter(ListEntitiesFilter.getter(ListEntitiesFilter::componentTypeId)).setter(ListEntitiesFilter.setter(Builder::componentTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentTypeId").build()}).build();
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentEntityId").getter(ListEntitiesFilter.getter(ListEntitiesFilter::parentEntityId)).setter(ListEntitiesFilter.setter(Builder::parentEntityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_TYPE_ID_FIELD, PARENT_ENTITY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String componentTypeId;
    private final String parentEntityId;
    private final Type type;

    private ListEntitiesFilter(BuilderImpl builder) {
        this.componentTypeId = builder.componentTypeId;
        this.parentEntityId = builder.parentEntityId;
        this.type = builder.type;
    }

    public final String componentTypeId() {
        return this.componentTypeId;
    }

    public final String parentEntityId() {
        return this.parentEntityId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentEntityId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntitiesFilter)) {
            return false;
        }
        ListEntitiesFilter other = (ListEntitiesFilter)obj;
        return Objects.equals(this.componentTypeId(), other.componentTypeId()) && Objects.equals(this.parentEntityId(), other.parentEntityId());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntitiesFilter").add("ComponentTypeId", (Object)this.componentTypeId()).add("ParentEntityId", (Object)this.parentEntityId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentTypeId": {
                return Optional.ofNullable(clazz.cast(this.componentTypeId()));
            }
            case "parentEntityId": {
                return Optional.ofNullable(clazz.cast(this.parentEntityId()));
            }
        }
        return Optional.empty();
    }

    public static ListEntitiesFilter fromComponentTypeId(String componentTypeId) {
        return (ListEntitiesFilter)ListEntitiesFilter.builder().componentTypeId(componentTypeId).build();
    }

    public static ListEntitiesFilter fromParentEntityId(String parentEntityId) {
        return (ListEntitiesFilter)ListEntitiesFilter.builder().parentEntityId(parentEntityId).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEntitiesFilter, T> g) {
        return obj -> g.apply((ListEntitiesFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COMPONENT_TYPE_ID,
        PARENT_ENTITY_ID,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String componentTypeId;
        private String parentEntityId;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntitiesFilter model) {
            this.componentTypeId(model.componentTypeId);
            this.parentEntityId(model.parentEntityId);
        }

        public final String getComponentTypeId() {
            return this.componentTypeId;
        }

        public final void setComponentTypeId(String componentTypeId) {
            String oldValue = this.componentTypeId;
            this.componentTypeId = componentTypeId;
            this.handleUnionValueChange(Type.COMPONENT_TYPE_ID, oldValue, this.componentTypeId);
        }

        @Override
        public final Builder componentTypeId(String componentTypeId) {
            String oldValue = this.componentTypeId;
            this.componentTypeId = componentTypeId;
            this.handleUnionValueChange(Type.COMPONENT_TYPE_ID, oldValue, this.componentTypeId);
            return this;
        }

        public final String getParentEntityId() {
            return this.parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            String oldValue = this.parentEntityId;
            this.parentEntityId = parentEntityId;
            this.handleUnionValueChange(Type.PARENT_ENTITY_ID, oldValue, this.parentEntityId);
        }

        @Override
        public final Builder parentEntityId(String parentEntityId) {
            String oldValue = this.parentEntityId;
            this.parentEntityId = parentEntityId;
            this.handleUnionValueChange(Type.PARENT_ENTITY_ID, oldValue, this.parentEntityId);
            return this;
        }

        public ListEntitiesFilter build() {
            return new ListEntitiesFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListEntitiesFilter> {
        public Builder componentTypeId(String var1);

        public Builder parentEntityId(String var1);
    }
}

